/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.response;

import com.karelherink.jdwpanalyzer.entity.FieldType;
import com.karelherink.jdwpanalyzer.entity.ReferenceType;
import com.karelherink.jdwpanalyzer.model.AnalyzerManager;
import com.karelherink.jdwpanalyzer.model.Node;
import com.karelherink.jdwpanalyzer.model.Packet;
import com.karelherink.jdwpanalyzer.model.PacketAnalyzer;
import com.karelherink.jdwpanalyzer.model.Request;
import java.util.ArrayList;

public class Analyzer_2_14
extends PacketAnalyzer {
    @Override
    public void updateInternalDataModel(Packet packet) {
        Request request = Request.getRequest(packet.getId());
        PacketAnalyzer requestPacketAnalyzer = AnalyzerManager.createPacketAnalyzer(request);
        Long referenceTypeId = (Long)requestPacketAnalyzer.getPacketInfo(request).getValue().getRealValue();
        ReferenceType referenceType = ReferenceType.getType(referenceTypeId);
        ArrayList fields = this.getPacketInfo(packet).getChildren();
        ArrayList<Long> fieldIDs = new ArrayList<Long>();
        for (int i = 0; i < fields.size(); ++i) {
            Node child = (Node)fields.get(i);
            Long fieldId = (Long)child.getValue().getRealValue();
            fieldIDs.add(fieldId);
            FieldType fieldType = FieldType.getType(referenceTypeId, fieldId);
            ArrayList grandChildren = child.getChildren();
            fieldType.setName((String)((Node)grandChildren.get(0)).getValue().getRealValue());
            fieldType.setSignature((String)((Node)grandChildren.get(1)).getValue().getRealValue());
            fieldType.setSignatureWithGeneric((String)((Node)grandChildren.get(2)).getValue().getRealValue());
            fieldType.setModBits((Integer)((Node)grandChildren.get(3)).getValue().getRealValue());
        }
        referenceType.setFieldIds(fieldIDs.toArray(new Long[fieldIDs.size()]));
    }

    @Override
    public Node getPacketInfo(Packet packet) {
        int index = 0;
        int numFields = (int)Analyzer_2_14.getVal(packet, index, 4);
        index += 4;
        Request request = Request.getRequest(packet.getId());
        PacketAnalyzer requestPacketAnalyzer = AnalyzerManager.createPacketAnalyzer(request);
        Long referenceTypeId = (Long)requestPacketAnalyzer.getPacketInfo(request).getValue().getRealValue();
        ReferenceType referenceType = ReferenceType.getType(referenceTypeId);
        Node root = new Node(new Node.Descriptor("NumFields:"), new Node.Value(new Integer(numFields)));
        for (int i = 0; i < numFields; ++i) {
            long fieldID = Analyzer_2_14.getVal(packet, index, fieldIDSize);
            FieldType fieldType = FieldType.getType(referenceTypeId, new Long(fieldID));
            Node singleFieldInfo = new Node(new Node.Descriptor("FieldID:", fieldType), new Node.Value(new Long(fieldID)));
            root.addChild(singleFieldInfo);
            int len = (int)Analyzer_2_14.getVal(packet, index += fieldIDSize, 4);
            Node singleFieldNameInfo = new Node(new Node.Descriptor("Name:"), new Node.Value(Analyzer_2_14.getStr(packet, index += 4, len)));
            index += len;
            singleFieldInfo.addChild(singleFieldNameInfo);
            len = (int)Analyzer_2_14.getVal(packet, index, 4);
            Node singleFieldSignatureInfo = new Node(new Node.Descriptor("Signature:"), new Node.Value(Analyzer_2_14.getStr(packet, index += 4, len)));
            index += len;
            singleFieldInfo.addChild(singleFieldSignatureInfo);
            len = (int)Analyzer_2_14.getVal(packet, index, 4);
            Node singleFieldGenericSignatureInfo = new Node(new Node.Descriptor("GenericSignature:"), new Node.Value(Analyzer_2_14.getStr(packet, index += 4, len)));
            singleFieldInfo.addChild(singleFieldGenericSignatureInfo);
            int modBits = (int)Analyzer_2_14.getVal(packet, index += len, 4);
            index += 4;
            Node singleFieldModBitsInfo = new Node(new Node.Descriptor("ModBits:"), new Node.Value(new Integer(modBits), Analyzer_2_14.getModBitsAsStr(modBits)));
            singleFieldInfo.addChild(singleFieldModBitsInfo);
        }
        return root;
    }
}

