/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.response;

import com.karelherink.jdwpanalyzer.entity.MethodType;
import com.karelherink.jdwpanalyzer.entity.ReferenceType;
import com.karelherink.jdwpanalyzer.model.AnalyzerManager;
import com.karelherink.jdwpanalyzer.model.Node;
import com.karelherink.jdwpanalyzer.model.Packet;
import com.karelherink.jdwpanalyzer.model.PacketAnalyzer;
import com.karelherink.jdwpanalyzer.model.Request;
import java.util.ArrayList;

public class Analyzer_2_5
extends PacketAnalyzer {
    @Override
    public void updateInternalDataModel(Packet packet) {
        Request request = Request.getRequest(packet.getId());
        PacketAnalyzer requestPacketAnalyzer = AnalyzerManager.createPacketAnalyzer(request);
        Long referenceTypeId = (Long)requestPacketAnalyzer.getPacketInfo(request).getValue().getRealValue();
        ReferenceType referenceType = ReferenceType.getType(referenceTypeId);
        ArrayList methods = this.getPacketInfo(packet).getChildren();
        ArrayList<Long> methodIDs = new ArrayList<Long>();
        for (Node child : methods) {
            Long methodId = (Long)child.getValue().getRealValue();
            methodIDs.add(methodId);
            MethodType methodType = MethodType.getType(referenceTypeId, methodId);
            ArrayList grandChildren = child.getChildren();
            methodType.setName((String)((Node)grandChildren.get(0)).getValue().getRealValue());
            methodType.setSignature((String)((Node)grandChildren.get(1)).getValue().getRealValue());
            methodType.setModBits((Integer)((Node)grandChildren.get(2)).getValue().getRealValue());
        }
        referenceType.setMethodIds(methodIDs.toArray(new Long[methodIDs.size()]));
    }

    @Override
    public Node getPacketInfo(Packet packet) {
        Request request = Request.getRequest(packet.getId());
        PacketAnalyzer requestPacketAnalyzer = AnalyzerManager.createPacketAnalyzer(request);
        Long referenceTypeId = (Long)requestPacketAnalyzer.getPacketInfo(request).getValue().getRealValue();
        int index = 0;
        int numMethods = (int)Analyzer_2_5.getVal(packet, index, 4);
        index += 4;
        Node root = new Node(new Node.Descriptor("NumMethods:"), new Node.Value(new Integer(numMethods)));
        for (int i = 0; i < numMethods; ++i) {
            long methodID = Analyzer_2_5.getVal(packet, index, methodIDSize);
            MethodType methodType = MethodType.getType(referenceTypeId, new Long(methodID));
            Node singleMethodInfo = new Node(new Node.Descriptor("MethodID:", methodType), new Node.Value(new Long(methodID)));
            root.addChild(singleMethodInfo);
            int len = (int)Analyzer_2_5.getVal(packet, index += methodIDSize, 4);
            Node singleMethodNameInfo = new Node(new Node.Descriptor("Name:"), new Node.Value(Analyzer_2_5.getStr(packet, index += 4, len)));
            index += len;
            singleMethodInfo.addChild(singleMethodNameInfo);
            len = (int)Analyzer_2_5.getVal(packet, index, 4);
            Node singleMethodSignatureInfo = new Node(new Node.Descriptor("Signature:"), new Node.Value(Analyzer_2_5.getStr(packet, index += 4, len)));
            singleMethodInfo.addChild(singleMethodSignatureInfo);
            int modBits = (int)Analyzer_2_5.getVal(packet, index += len, 4);
            index += 4;
            Node singleMethodModBitsInfo = new Node(new Node.Descriptor("ModBits:"), new Node.Value(new Integer(modBits), Analyzer_2_5.getModBitsAsStr(modBits)));
            singleMethodInfo.addChild(singleMethodModBitsInfo);
        }
        return root;
    }
}

