/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.response;

import com.karelherink.jdwpanalyzer.entity.ReferenceType;
import com.karelherink.jdwpanalyzer.model.AnalyzerManager;
import com.karelherink.jdwpanalyzer.model.Node;
import com.karelherink.jdwpanalyzer.model.Packet;
import com.karelherink.jdwpanalyzer.model.PacketAnalyzer;
import com.karelherink.jdwpanalyzer.model.Request;
import com.karelherink.jdwpanalyzer.model.constants.TypeTag;
import java.util.ArrayList;

public class Analyzer_2_8
extends PacketAnalyzer {
    @Override
    public void updateInternalDataModel(Packet packet) {
        Request request = Request.getRequest(packet.getId());
        PacketAnalyzer requestPacketAnalyzer = AnalyzerManager.createPacketAnalyzer(request);
        Long referenceTypeId = (Long)requestPacketAnalyzer.getPacketInfo(request).getValue().getRealValue();
        ReferenceType referenceType = ReferenceType.getType(referenceTypeId);
        ArrayList<Long> nestedClassesRefTypeIds = new ArrayList<Long>();
        ArrayList classesInfo = this.getPacketInfo(packet).getChildren();
        for (int i = 0; i < classesInfo.size(); ++i) {
            Node singleClassInfo = (Node)classesInfo.get(i);
            Long nestedRefTypeId = (Long)singleClassInfo.getValue().getRealValue();
            nestedClassesRefTypeIds.add(nestedRefTypeId);
            Node typeTag = (Node)singleClassInfo.getChildren().get(0);
            ReferenceType nestedRefType = ReferenceType.getType(nestedRefTypeId);
            nestedRefType.setTypeTag((Byte)typeTag.getValue().getRealValue());
        }
    }

    @Override
    public Node getPacketInfo(Packet packet) {
        int index = 0;
        int numClasses = (int)Analyzer_2_8.getVal(packet, index, 4);
        index += 4;
        Node classesInfo = new Node(new Node.Descriptor("NumClasses:"), new Node.Value(new Integer(numClasses)));
        for (int i = 0; i < numClasses; ++i) {
            byte typeTag = (byte)(packet.getData()[index++] & 0xFF);
            long refTypeId = Analyzer_2_8.getVal(packet, index, referenceTypeIDSize);
            index += referenceTypeIDSize;
            ReferenceType referenceType = ReferenceType.getType(refTypeId);
            Node singleClassInfo = new Node(new Node.Descriptor("RefTypeID:", referenceType), new Node.Value(new Long(refTypeId)));
            classesInfo.addChild(singleClassInfo);
            Node typeTagInfo = new Node(new Node.Descriptor("TypeTag:"), new Node.Value(new Byte(typeTag), TypeTag.asString(typeTag)));
            singleClassInfo.addChild(typeTagInfo);
        }
        return classesInfo;
    }
}

