/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.response;

import com.karelherink.jdwpanalyzer.entity.MethodType;
import com.karelherink.jdwpanalyzer.model.AnalyzerManager;
import com.karelherink.jdwpanalyzer.model.Node;
import com.karelherink.jdwpanalyzer.model.Packet;
import com.karelherink.jdwpanalyzer.model.PacketAnalyzer;
import com.karelherink.jdwpanalyzer.model.Request;
import java.util.ArrayList;
import java.util.Iterator;

public class Analyzer_6_1
extends PacketAnalyzer {
    @Override
    public void updateInternalDataModel(Packet packet) {
        Request request = Request.getRequest(packet.getId());
        PacketAnalyzer requestPacketAnalyzer = AnalyzerManager.createPacketAnalyzer(request);
        ArrayList requestChildren = requestPacketAnalyzer.getPacketInfo(request).getChildren();
        Long referenceTypeId = (Long)((Node)requestChildren.get(0)).getValue().getRealValue();
        Long methId = (Long)((Node)requestChildren.get(1)).getValue().getRealValue();
        MethodType methType = MethodType.getType(referenceTypeId, methId);
        ArrayList nodes = this.getPacketInfo(packet).getChildren();
        Long startIndex = (Long)((Node)nodes.get(0)).getValue().getRealValue();
        methType.setStartCodeIndex(startIndex);
        Long endIndex = (Long)((Node)nodes.get(1)).getValue().getRealValue();
        methType.setEndCodeIndex(endIndex);
        Node lineInfo = (Node)nodes.get(2);
        Integer numLines = (Integer)lineInfo.getValue().getRealValue();
        methType.setNumLines(numLines);
        ArrayList lines = lineInfo.getChildren();
        ArrayList<MethodType.LineMapping> lineMappings = new ArrayList<MethodType.LineMapping>();
        Iterator iter = lines.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            Long lineCodeIndex = (Long)node.getValue().getRealValue();
            node = (Node)iter.next();
            Integer lineNumber = (Integer)node.getValue().getRealValue();
            MethodType.LineMapping mapping = new MethodType.LineMapping(lineCodeIndex, lineNumber);
            lineMappings.add(mapping);
        }
        methType.setLineMapping(lineMappings.toArray(new MethodType.LineMapping[lineMappings.size()]));
    }

    @Override
    public Node getPacketInfo(Packet packet) {
        Node root = new Node(null, null);
        int index = 0;
        long startIndex = Analyzer_6_1.getVal(packet, index, 8);
        Node startIndexInfo = new Node(new Node.Descriptor("StartIndex:"), new Node.Value(new Long(startIndex)));
        root.addChild(startIndexInfo);
        long endIndex = Analyzer_6_1.getVal(packet, index += 8, 8);
        Node endIndexInfo = new Node(new Node.Descriptor("EndIndex:"), new Node.Value(new Long(endIndex)));
        root.addChild(endIndexInfo);
        int numLines = (int)Analyzer_6_1.getVal(packet, index += 8, 4);
        index += 4;
        Node lineInfo = new Node(new Node.Descriptor("NumLines:"), new Node.Value(new Integer(numLines)));
        root.addChild(lineInfo);
        for (int i = 0; i < numLines; ++i) {
            long codeIndex = Analyzer_6_1.getVal(packet, index, 8);
            Node codeIndexInfo = new Node(new Node.Descriptor("LineCodeIndex:"), new Node.Value(new Long(codeIndex)));
            lineInfo.addChild(codeIndexInfo);
            int lineNum = (int)Analyzer_6_1.getVal(packet, index += 8, 4);
            index += 4;
            Node lineNumInfo = new Node(new Node.Descriptor("LineNumber:"), new Node.Value(new Integer(lineNum)));
            lineInfo.addChild(lineNumInfo);
        }
        return root;
    }
}

