/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.response;

import com.karelherink.jdwpanalyzer.entity.MethodType;
import com.karelherink.jdwpanalyzer.model.AnalyzerManager;
import com.karelherink.jdwpanalyzer.model.Node;
import com.karelherink.jdwpanalyzer.model.Packet;
import com.karelherink.jdwpanalyzer.model.PacketAnalyzer;
import com.karelherink.jdwpanalyzer.model.Request;
import java.util.ArrayList;

public class Analyzer_6_3
extends PacketAnalyzer {
    @Override
    public void updateInternalDataModel(Packet packet) {
        Request request = Request.getRequest(packet.getId());
        PacketAnalyzer requestPacketAnalyzer = AnalyzerManager.createPacketAnalyzer(request);
        ArrayList requestChildren = requestPacketAnalyzer.getPacketInfo(request).getChildren();
        Long referenceTypeId = (Long)((Node)requestChildren.get(0)).getValue().getRealValue();
        Long methId = (Long)((Node)requestChildren.get(1)).getValue().getRealValue();
        MethodType methType = MethodType.getType(referenceTypeId, methId);
        Node node = this.getPacketInfo(packet);
        Node byteCodeNode = (Node)node.getChildren().get(0);
        byte[] byteCode = (byte[])byteCodeNode.getValue().getRealValue();
        methType.setByteCode(byteCode);
    }

    @Override
    public Node getPacketInfo(Packet packet) {
        Request request = Request.getRequest(packet.getId());
        PacketAnalyzer requestPacketAnalyzer = AnalyzerManager.createPacketAnalyzer(request);
        ArrayList requestChildren = requestPacketAnalyzer.getPacketInfo(request).getChildren();
        Long referenceTypeId = (Long)((Node)requestChildren.get(0)).getValue().getRealValue();
        Long methId = (Long)((Node)requestChildren.get(1)).getValue().getRealValue();
        MethodType methType = MethodType.getType(referenceTypeId, methId);
        int index = 0;
        int numMethodBytes = (int)Analyzer_6_3.getVal(packet, index, 4);
        byte[] methodBytes = new byte[numMethodBytes];
        System.arraycopy(packet.getData(), index += 4, methodBytes, 0, numMethodBytes);
        index += numMethodBytes;
        Node byteInfo = new Node(new Node.Descriptor("Bytes:", methType), new Node.Value(methodBytes, Integer.toString(numMethodBytes)));
        return byteInfo;
    }
}

