/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.response;

import com.karelherink.jdwpanalyzer.entity.MethodType;
import com.karelherink.jdwpanalyzer.model.AnalyzerManager;
import com.karelherink.jdwpanalyzer.model.Node;
import com.karelherink.jdwpanalyzer.model.Packet;
import com.karelherink.jdwpanalyzer.model.PacketAnalyzer;
import com.karelherink.jdwpanalyzer.model.Request;
import java.util.ArrayList;
import java.util.Iterator;

public class Analyzer_6_5
extends PacketAnalyzer {
    @Override
    public void updateInternalDataModel(Packet packet) {
        Request request = Request.getRequest(packet.getId());
        PacketAnalyzer requestPacketAnalyzer = AnalyzerManager.createPacketAnalyzer(request);
        ArrayList requestChildren = requestPacketAnalyzer.getPacketInfo(request).getChildren();
        Long referenceTypeId = (Long)((Node)requestChildren.get(0)).getValue().getRealValue();
        Long methId = (Long)((Node)requestChildren.get(1)).getValue().getRealValue();
        MethodType methType = MethodType.getType(referenceTypeId, methId);
        ArrayList nodes = this.getPacketInfo(packet).getChildren();
        Integer argCnt = (Integer)((Node)nodes.get(0)).getValue().getRealValue();
        methType.setArgCount(argCnt);
        Node varsInfo = (Node)nodes.get(1);
        ArrayList varData = varsInfo.getChildren();
        ArrayList<MethodType.Variable> variables = new ArrayList<MethodType.Variable>();
        Iterator iter = varData.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            Long codeIndex = (Long)node.getValue().getRealValue();
            node = (Node)iter.next();
            String name = (String)node.getValue().getRealValue();
            node = (Node)iter.next();
            String signature = (String)node.getValue().getRealValue();
            node = (Node)iter.next();
            String genericSignature = (String)node.getValue().getRealValue();
            node = (Node)iter.next();
            Integer lenght = (Integer)node.getValue().getRealValue();
            node = (Node)iter.next();
            Integer frameIndex = (Integer)node.getValue().getRealValue();
            MethodType.Variable variable = new MethodType.Variable(codeIndex, name, signature, genericSignature, lenght, frameIndex);
            variables.add(variable);
        }
        methType.setVariables(variables.toArray(new MethodType.Variable[variables.size()]));
    }

    @Override
    public Node getPacketInfo(Packet packet) {
        Node root = new Node(null, null);
        int index = 0;
        int argCnt = (int)Analyzer_6_5.getVal(packet, index, 4);
        Node argCntInfo = new Node(new Node.Descriptor("ArgCount:"), new Node.Value(new Integer(argCnt)));
        root.addChild(argCntInfo);
        int numVars = (int)Analyzer_6_5.getVal(packet, index += 4, 4);
        index += 4;
        Node varsInfo = new Node(new Node.Descriptor("NumVariables:"), new Node.Value(new Integer(numVars)));
        root.addChild(varsInfo);
        for (int i = 0; i < numVars; ++i) {
            long codeIndex = Analyzer_6_5.getVal(packet, index, 8);
            Node codeIndexInfo = new Node(new Node.Descriptor("CodeIndex:"), new Node.Value(new Long(codeIndex)));
            varsInfo.addChild(codeIndexInfo);
            int len = (int)Analyzer_6_5.getVal(packet, index += 8, 4);
            Node nameInfo = new Node(new Node.Descriptor("Name:"), new Node.Value(Analyzer_6_5.getStr(packet, index += 4, len)));
            index += len;
            varsInfo.addChild(nameInfo);
            len = (int)Analyzer_6_5.getVal(packet, index, 4);
            Node signatureInfo = new Node(new Node.Descriptor("Signature:"), new Node.Value(Analyzer_6_5.getStr(packet, index += 4, len)));
            index += len;
            varsInfo.addChild(signatureInfo);
            len = (int)Analyzer_6_5.getVal(packet, index, 4);
            Node genericSignatureInfo = new Node(new Node.Descriptor("GenericSignature:"), new Node.Value(Analyzer_6_5.getStr(packet, index += 4, len)));
            varsInfo.addChild(genericSignatureInfo);
            int lenght = (int)Analyzer_6_5.getVal(packet, index += len, 4);
            Node lenghtInfo = new Node(new Node.Descriptor("Lenght:"), new Node.Value(new Integer(lenght)));
            varsInfo.addChild(lenghtInfo);
            int frameIndex = (int)Analyzer_6_5.getVal(packet, index += 4, 4);
            index += 4;
            Node frameIndexInfo = new Node(new Node.Descriptor("FrameIndex:"), new Node.Value(new Integer(frameIndex)));
            varsInfo.addChild(frameIndexInfo);
        }
        return root;
    }
}

