/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.response;

import com.karelherink.jdwpanalyzer.entity.ObjectType;
import com.karelherink.jdwpanalyzer.model.AnalyzerManager;
import com.karelherink.jdwpanalyzer.model.Node;
import com.karelherink.jdwpanalyzer.model.Packet;
import com.karelherink.jdwpanalyzer.model.PacketAnalyzer;
import com.karelherink.jdwpanalyzer.model.Request;
import java.util.ArrayList;

public class Analyzer_9_5
extends PacketAnalyzer {
    @Override
    public void updateInternalDataModel(Packet packet) {
        Request request = Request.getRequest(packet.getId());
        PacketAnalyzer requestPacketAnalyzer = AnalyzerManager.createPacketAnalyzer(request);
        Long objTypeId = (Long)requestPacketAnalyzer.getPacketInfo(request).getValue().getRealValue();
        ObjectType objectType = ObjectType.getType(objTypeId);
        ArrayList nodes = this.getPacketInfo(packet).getChildren();
        Long ownerThreadId = (Long)((Node)nodes.get(0)).getValue().getRealValue();
        objectType.setOwnerThreadId(ownerThreadId);
        Integer entrycount = (Integer)((Node)nodes.get(1)).getValue().getRealValue();
        objectType.setMonitorEntryCount(entrycount);
        ArrayList waitingThreads = ((Node)nodes.get(2)).getChildren();
        ArrayList<Long> waitingThreadIds = new ArrayList<Long>();
        for (Node waitThreadNode : waitingThreads) {
            Long id = (Long)waitThreadNode.getValue().getRealValue();
            waitingThreadIds.add(id);
        }
        objectType.setWaitingThreadIds(waitingThreadIds.toArray(new Long[waitingThreadIds.size()]));
    }

    @Override
    public Node getPacketInfo(Packet packet) {
        Node root = new Node(null, null);
        int index = 0;
        long threadTypeId = Analyzer_9_5.getVal(packet, index, objectIDSize);
        ObjectType threadType = ObjectType.getType(threadTypeId);
        Node threadInfo = new Node(new Node.Descriptor("ThreadID:", threadType), new Node.Value(new Long(threadTypeId)));
        root.addChild(threadInfo);
        int entryCount = (int)Analyzer_9_5.getVal(packet, index += objectIDSize, 4);
        Node entryInfo = new Node(new Node.Descriptor("EntryCount:"), new Node.Value(new Integer(entryCount)));
        root.addChild(entryInfo);
        int numWaiters = (int)Analyzer_9_5.getVal(packet, index += 4, 4);
        index += 4;
        Node waitersInfo = new Node(new Node.Descriptor("NumWaitingThreads:"), new Node.Value(new Integer(numWaiters)));
        root.addChild(waitersInfo);
        for (int i = 0; i < numWaiters; ++i) {
            long waitingThreadTypeId = Analyzer_9_5.getVal(packet, index, objectIDSize);
            index += objectIDSize;
            ObjectType waitingThreadType = ObjectType.getType(waitingThreadTypeId);
            Node waitThreadInfo = new Node(new Node.Descriptor("WaitingThreadID:", waitingThreadType), new Node.Value(new Long(waitingThreadTypeId)));
            waitersInfo.addChild(waitThreadInfo);
        }
        return root;
    }
}

