/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.ui;

import com.karelherink.jdwpanalyzer.model.Packet;
import com.karelherink.jdwpanalyzer.model.Request;
import com.karelherink.jdwpanalyzer.model.Response;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class JDWPTableModel
implements TableModel {
    private static final int REQUEST_COL = 0;
    private static final int RESPONSE_COL = 1;
    private static final int COL_COUNT = 2;
    private List tableModelListeners = new ArrayList();
    private List sequentialRequests;

    public JDWPTableModel(List sequentialRequests) {
        this.sequentialRequests = sequentialRequests;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.sequentialRequests.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Class getColumnClass(int columnIndex) {
        return Packet.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || columnIndex < 0 || rowIndex >= this.sequentialRequests.size() || columnIndex >= 2) {
            return null;
        }
        Request request = (Request)this.sequentialRequests.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return request;
            }
            case 1: {
                int id = request.getId();
                Response response = Response.getResponse(id);
                if (response == null) {
                    return null;
                }
                return response;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Requests";
            }
            case 1: {
                return "Responses";
            }
        }
        return "FIX getColumnName()";
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.tableModelListeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.tableModelListeners.remove(l);
    }

    public int[] update(Packet packet) {
        int[] position = this.getPacketTablePosition(packet);
        TableModelEvent event = new TableModelEvent(this, position[0], position[0], position[1], 1);
        for (TableModelListener listener : this.tableModelListeners) {
            listener.tableChanged(event);
        }
        return position;
    }

    private int[] getPacketTablePosition(Packet packet) {
        int[] position = new int[2];
        if (packet.isResponse()) {
            Request request = Request.getRequest(packet.getId());
            position[0] = request.getSequentialRequestNumber();
            position[1] = 1;
        } else {
            Request request = (Request)packet;
            position[0] = request.getSequentialRequestNumber();
            position[1] = 0;
        }
        return position;
    }
}

