/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.ui;

import com.karelherink.jdwpanalyzer.model.Node;
import java.util.ArrayList;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class PacketDetailTableModel
implements TableModel {
    private ArrayList tableModelListeners = new ArrayList();
    private ArrayList descriptions;
    private ArrayList values;
    private static final int NUM_COLS = 2;

    public PacketDetailTableModel(Node node) {
        this.initFlatNodeStructure(node);
    }

    private void initFlatNodeStructure(Node node) {
        this.descriptions = new ArrayList();
        this.values = new ArrayList();
        this.addToStructure(node);
        this.updateStructureRecursive(node.getChildren());
    }

    private void updateStructureRecursive(ArrayList children) {
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.size(); ++i) {
            Node child = (Node)children.get(i);
            this.addToStructure(child);
            this.updateStructureRecursive(child.getChildren());
        }
    }

    private void addToStructure(Node node) {
        if (node.getDescriptor() == null && node.getValue() == null) {
            return;
        }
        this.descriptions.add(node.getDescriptor());
        this.values.add(node.getValue());
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.descriptions.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Node.Descriptor.class;
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount() || columnIndex < 0 || columnIndex >= this.getColumnCount()) {
            return null;
        }
        if (columnIndex == 0) {
            return this.descriptions.get(rowIndex);
        }
        Node.Value value = (Node.Value)this.values.get(rowIndex);
        return value;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public String getColumnName(int columnIndex) {
        return columnIndex == 0 ? "Description" : "Value";
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.tableModelListeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.tableModelListeners.remove(l);
    }
}

