/*
 * Decompiled with CFR 0.152.
 */
package com.karelherink.jdwpanalyzer.ui;

import com.karelherink.jdwpanalyzer.entity.Type;
import com.karelherink.jdwpanalyzer.model.AnalyzerManager;
import com.karelherink.jdwpanalyzer.model.JDWPProxy;
import com.karelherink.jdwpanalyzer.model.Node;
import com.karelherink.jdwpanalyzer.model.Packet;
import com.karelherink.jdwpanalyzer.model.PacketAnalyzer;
import com.karelherink.jdwpanalyzer.model.Response;
import com.karelherink.jdwpanalyzer.ui.JDWPListModel;
import com.karelherink.jdwpanalyzer.ui.JDWPTableModel;
import com.karelherink.jdwpanalyzer.ui.ListPacketRenderer;
import com.karelherink.jdwpanalyzer.ui.PacketDetailTableModel;
import com.karelherink.jdwpanalyzer.ui.TablePacketRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class View {
    private JFrame mainFrame;
    private JPanel mainViewPanel;
    private JPanel topPanel;
    private JPanel detailPanel;
    private JPanel detailPacketPanel;
    private JPanel detailTypePanel;
    private JSplitPane topHorizontalSplit;
    private JSplitPane detailVerticalSplit;
    private JTable packetTable;
    private JTable detailPacketTable;
    private JDWPTableModel packetTableModel;
    private JScrollPane packetTableScroll;
    private JList sequenceList;
    private JDWPListModel sequenceListModel;
    private JScrollPane sequenceListScroll;
    private JSplitPane mainVerticalSplit;
    private JDWPProxy proxy;

    public View(JDWPProxy proxy, List sequentialRequests) {
        this.proxy = proxy;
        this.mainFrame = new JFrame("ZeroEffort JDWP Analyzer");
        this.packetTableModel = new JDWPTableModel(sequentialRequests);
        this.packetTable = new JTable(this.packetTableModel);
        this.packetTable.setDefaultRenderer(Packet.class, new TablePacketRenderer());
        this.packetTable.setCellSelectionEnabled(true);
        PacketTableUIListener listener = new PacketTableUIListener();
        this.packetTable.getColumnModel().getSelectionModel().addListSelectionListener(listener);
        this.packetTable.getSelectionModel().addListSelectionListener(listener);
        this.packetTable.addFocusListener(listener);
        this.packetTableScroll = new JScrollPane(this.packetTable);
        this.detailPanel = new JPanel();
        this.detailPanel.setLayout(new BorderLayout());
        this.detailVerticalSplit = new JSplitPane(0);
        this.detailPacketPanel = new JPanel();
        this.detailTypePanel = new JPanel();
        this.detailPacketPanel.setLayout(new BorderLayout());
        this.detailTypePanel.setLayout(new BorderLayout());
        this.detailPacketPanel.add((Component)new JTextField("No detail available."), "Center");
        this.detailTypePanel.add((Component)new JTextField("No detail available."), "Center");
        this.detailVerticalSplit.setDividerSize(2);
        this.detailVerticalSplit.add(this.detailPacketPanel);
        this.detailVerticalSplit.add(this.detailTypePanel);
        this.detailVerticalSplit.setDividerLocation(250);
        this.detailPanel.add((Component)this.detailVerticalSplit, "Center");
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BorderLayout());
        this.topHorizontalSplit = new JSplitPane(1);
        this.topHorizontalSplit.setDividerSize(2);
        this.topHorizontalSplit.add(this.packetTableScroll);
        this.topHorizontalSplit.add(this.detailPanel);
        this.topPanel.add(this.topHorizontalSplit);
        this.sequenceListModel = new JDWPListModel();
        this.sequenceList = new JList(this.sequenceListModel);
        this.sequenceList.setCellRenderer(new ListPacketRenderer());
        this.sequenceList.setSelectionMode(0);
        this.sequenceList.addListSelectionListener(new SequenceListUIListener());
        this.sequenceList.addFocusListener(new SequenceListUIListener());
        this.sequenceListScroll = new JScrollPane(this.sequenceList);
        this.mainVerticalSplit = new JSplitPane(0);
        this.mainVerticalSplit.setDividerSize(2);
        this.mainVerticalSplit.add(this.topPanel);
        this.mainVerticalSplit.add(this.sequenceListScroll);
        this.mainViewPanel = new JPanel();
        this.mainViewPanel.setLayout(new BorderLayout());
        this.mainViewPanel.add((Component)this.mainVerticalSplit, "Center");
        Container container = this.mainFrame.getContentPane();
        container.setLayout(new GridLayout(1, 1));
        container.add(this.mainViewPanel);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                View.this.proxy.shutDown();
            }
        });
        this.mainFrame.setSize(900, 600);
        this.mainFrame.validate();
        this.mainFrame.setVisible(true);
    }

    public void updateView(Packet packet) {
        EventQueue.invokeLater(new ViewUpdater(packet));
    }

    private JTable getDetailPacketTable(Packet packet) {
        PacketAnalyzer pa = AnalyzerManager.createPacketAnalyzer(packet);
        Node info = pa.getPacketInfo(packet);
        PacketDetailTableModel tableModel = new PacketDetailTableModel(info);
        JTable table = new JTable(tableModel);
        DetailPacketTableUIListener listener = new DetailPacketTableUIListener();
        table.getColumnModel().getSelectionModel().addListSelectionListener(listener);
        table.getSelectionModel().addListSelectionListener(listener);
        table.addFocusListener(listener);
        return table;
    }

    private class DetailPacketTableUIListener
    implements ListSelectionListener,
    FocusListener {
        private DetailPacketTableUIListener() {
        }

        private void updateDetailedViewForType() {
            int rowIndex = View.this.detailPacketTable.getSelectedRow();
            Node.Descriptor descriptor = (Node.Descriptor)View.this.detailPacketTable.getValueAt(rowIndex, 0);
            if (descriptor == null || descriptor.getAssociatedType() == null) {
                return;
            }
            Type type = descriptor.getAssociatedType();
            final Component typeView = type.getTypeDetailedView();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    View.this.detailTypePanel.removeAll();
                    JScrollPane typeTableScroll = new JScrollPane(typeView);
                    View.this.detailTypePanel.add((Component)typeTableScroll, "Center");
                    View.this.mainFrame.validate();
                }
            });
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (lsm.isSelectionEmpty()) {
                return;
            }
            this.updateDetailedViewForType();
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.updateDetailedViewForType();
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    private class DetailPacketViewUpdater
    implements Runnable {
        private Component detailedView;

        public DetailPacketViewUpdater(Component detailedView) {
            this.detailedView = detailedView;
        }

        @Override
        public void run() {
            View.this.detailPacketPanel.removeAll();
            JScrollPane packetTableScroll = new JScrollPane(this.detailedView);
            View.this.detailPacketPanel.add(packetTableScroll);
            View.this.mainFrame.validate();
        }
    }

    private class SequenceListUIListener
    implements ListSelectionListener,
    FocusListener {
        private SequenceListUIListener() {
        }

        private void updateDetailedViewForPacket(int selectedIndex) {
            Response resp;
            Packet packet = (Packet)View.this.sequenceList.getModel().getElementAt(selectedIndex);
            if (packet.isResponse() && (resp = (Response)packet).isError()) {
                return;
            }
            View.this.detailPacketTable = View.this.getDetailPacketTable(packet);
            EventQueue.invokeLater(new DetailPacketViewUpdater(View.this.detailPacketTable));
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedIndex = ((JList)e.getSource()).getSelectedIndex();
            if (e.getValueIsAdjusting() || selectedIndex == -1) {
                return;
            }
            this.updateDetailedViewForPacket(selectedIndex);
        }

        @Override
        public void focusGained(FocusEvent e) {
            int selectedIndex = View.this.sequenceList.getSelectedIndex();
            if (selectedIndex == -1) {
                return;
            }
            this.updateDetailedViewForPacket(selectedIndex);
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    private class PacketTableUIListener
    implements ListSelectionListener,
    FocusListener {
        private PacketTableUIListener() {
        }

        private void updateDetailedViewForPacket() {
            Response resp;
            int colIndex = View.this.packetTable.getSelectedColumn();
            int rowIndex = View.this.packetTable.getSelectedRow();
            Packet packet = (Packet)View.this.packetTable.getModel().getValueAt(rowIndex, colIndex);
            if (packet == null) {
                return;
            }
            if (packet.isResponse() && (resp = (Response)packet).isError()) {
                return;
            }
            View.this.detailPacketTable = View.this.getDetailPacketTable(packet);
            EventQueue.invokeLater(new DetailPacketViewUpdater(View.this.detailPacketTable));
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (lsm.isSelectionEmpty()) {
                return;
            }
            this.updateDetailedViewForPacket();
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.updateDetailedViewForPacket();
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    private class ViewUpdater
    implements Runnable {
        private Packet packet;

        ViewUpdater(Packet packet) {
            this.packet = packet;
        }

        @Override
        public void run() {
            int[] cellPosition = View.this.packetTableModel.update(this.packet);
            int position = View.this.sequenceListModel.update(this.packet);
            Rectangle tableRect = View.this.packetTable.getCellRect(cellPosition[0], cellPosition[1], true);
            Rectangle listRect = View.this.sequenceList.getCellBounds(position, position);
            View.this.packetTableScroll.getViewport().scrollRectToVisible(tableRect);
            View.this.sequenceListScroll.getViewport().scrollRectToVisible(listRect);
        }
    }
}

