/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.commons;

import com.badlogic.gdx.jnigen.commons.Platform;

public enum Os {
    Windows(Platform.Desktop),
    Linux(Platform.Desktop),
    MacOsX(Platform.Desktop),
    Android(Platform.Android),
    IOS(Platform.IOS);

    private final Platform platform;

    private Os(Platform platform) {
        this.platform = platform;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public String getJniPlatform() {
        if (this == Windows) {
            return "win32";
        }
        if (this == Linux) {
            return "linux";
        }
        if (this == MacOsX) {
            return "mac";
        }
        if (this == IOS) {
            return "mac";
        }
        return "";
    }

    public String getLibPrefix() {
        if (this == Linux || this == Android || this == MacOsX) {
            return "lib";
        }
        return "";
    }

    public String getLibExtension() {
        if (this == Windows) {
            return "dll";
        }
        if (this == Linux) {
            return "so";
        }
        if (this == MacOsX) {
            return "dylib";
        }
        if (this == Android) {
            return "so";
        }
        return "";
    }
}

