/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.generator;

import com.badlogic.gdx.jnigen.generator.ClangUtils;
import com.badlogic.gdx.jnigen.generator.Manager;
import com.badlogic.gdx.jnigen.generator.parser.CommentParser;
import com.badlogic.gdx.jnigen.generator.parser.EnumParser;
import com.badlogic.gdx.jnigen.generator.parser.StackElementParser;
import com.badlogic.gdx.jnigen.generator.types.ClosureType;
import com.badlogic.gdx.jnigen.generator.types.FunctionSignature;
import com.badlogic.gdx.jnigen.generator.types.FunctionType;
import com.badlogic.gdx.jnigen.generator.types.MacroType;
import com.badlogic.gdx.jnigen.generator.types.MappedType;
import com.badlogic.gdx.jnigen.generator.types.NamedType;
import com.badlogic.gdx.jnigen.generator.types.PointerType;
import com.badlogic.gdx.jnigen.generator.types.PrimitiveType;
import com.badlogic.gdx.jnigen.generator.types.TypeDefinition;
import com.badlogic.gdx.jnigen.generator.types.TypeKind;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.llvm.clang.CXClientData;
import org.bytedeco.llvm.clang.CXCursor;
import org.bytedeco.llvm.clang.CXCursorVisitor;
import org.bytedeco.llvm.clang.CXIndex;
import org.bytedeco.llvm.clang.CXSourceLocation;
import org.bytedeco.llvm.clang.CXSourceRange;
import org.bytedeco.llvm.clang.CXToken;
import org.bytedeco.llvm.clang.CXTranslationUnit;
import org.bytedeco.llvm.clang.CXType;
import org.bytedeco.llvm.global.clang;

public class Generator {
    private static File createTempParsableFile(String fileToParse) {
        try {
            Path path = Files.createTempFile("jnigen-generator", ".c", new FileAttribute[0]);
            Files.write(path, ("#include <" + fileToParse + ">\n").getBytes(), new OpenOption[0]);
            return path.toFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static TypeDefinition registerCXType(CXType type, String alternativeName, MappedType parent) {
        if (type.kind() == 163) {
            type = clang.clang_Type_getModifiedType((CXType)type);
        }
        TypeKind typeKind = TypeKind.getTypeKind(type);
        String name = clang.clang_getTypeSpelling((CXType)type).getString();
        if (name.equals("_Bool")) {
            name = "bool";
        }
        if (!typeKind.isSpecial()) {
            TypeDefinition typeDefinition = TypeDefinition.get(typeKind, name);
            PrimitiveType mappedType = new PrimitiveType(typeDefinition);
            typeDefinition.setOverrideMappedType(mappedType);
            return typeDefinition;
        }
        if (clang.clang_getTypeDeclaration((CXType)type).kind() == 20) {
            CXType typeDef = clang.clang_getTypedefDeclUnderlyingType((CXCursor)clang.clang_getTypeDeclaration((CXType)type));
            Manager.getInstance().registerTypeDef(clang.clang_getTypedefName((CXType)type).getString(), clang.clang_getTypeSpelling((CXType)typeDef).getString());
            TypeDefinition lower = Generator.registerCXType(typeDef, clang.clang_getTypedefName((CXType)type).getString(), null);
            if (lower.getTypeKind() == TypeKind.CLOSURE) {
                Generator.patchClosureTypeWithCursor(lower, clang.clang_getTypeDeclaration((CXType)type));
            }
            TypeDefinition definition = TypeDefinition.get(lower.getTypeKind(), clang.clang_getTypedefName((CXType)type).getString());
            definition.setOverrideMappedType(lower.getMappedType());
            return definition;
        }
        if (typeKind == TypeKind.CLOSURE) {
            if (alternativeName == null) {
                throw new IllegalArgumentException();
            }
            if (Manager.getInstance().hasCTypeMapping(alternativeName)) {
                return Manager.getInstance().resolveCTypeMapping(alternativeName);
            }
            MappedType parentMappedType = parent == null ? Manager.getInstance().getGlobalType() : parent;
            FunctionSignature functionSignature = Generator.parseFunctionSignature(alternativeName, type, null);
            if (Manager.getInstance().hasCTypeMapping(alternativeName)) {
                return Manager.getInstance().resolveCTypeMapping(alternativeName);
            }
            ClosureType closureType = new ClosureType(functionSignature, parentMappedType);
            TypeDefinition typeDefinition = TypeDefinition.get(TypeKind.CLOSURE, name);
            typeDefinition.setOverrideMappedType(closureType);
            typeDefinition.setAnonymous(parent != null);
            if (!typeDefinition.isAnonymous()) {
                Manager.getInstance().addClosure(closureType);
                Manager.getInstance().registerCTypeMapping(alternativeName, typeDefinition);
            }
            return typeDefinition;
        }
        if (Manager.getInstance().hasCTypeMapping(name)) {
            return Manager.getInstance().resolveCTypeMapping(name);
        }
        if (type.kind() == 101) {
            CXType pointee = clang.clang_getPointeeType((CXType)type);
            TypeDefinition typeDefinition = TypeDefinition.get(TypeKind.POINTER, name);
            if (pointee.kind() == 0) {
                typeDefinition.setOverrideMappedType(new PointerType(TypeDefinition.get(TypeKind.VOID, "void")));
            }
            TypeDefinition nested = Generator.registerCXType(pointee, alternativeName, parent);
            if (TypeKind.getTypeKind(pointee) == TypeKind.CLOSURE) {
                typeDefinition = TypeDefinition.get(TypeKind.CLOSURE, name);
                typeDefinition.setOverrideMappedType(nested.getMappedType());
                typeDefinition.setAnonymous(nested.isAnonymous());
            } else {
                typeDefinition.setOverrideMappedType(new PointerType(nested));
                typeDefinition.setNestedDefinition(nested);
            }
            return typeDefinition;
        }
        if (type.kind() == 114) {
            TypeDefinition typeDefinition = TypeDefinition.get(TypeKind.POINTER, name.replace("[]", "*"));
            TypeDefinition nested = Generator.registerCXType(clang.clang_getArrayElementType((CXType)type), alternativeName, parent);
            typeDefinition.setOverrideMappedType(new PointerType(nested));
            typeDefinition.setNestedDefinition(nested);
            return typeDefinition;
        }
        if (type.kind() == 112) {
            TypeDefinition typeDefinition = TypeDefinition.get(TypeKind.FIXED_SIZE_ARRAY, name);
            typeDefinition.setCount((int)clang.clang_getArraySize((CXType)type));
            TypeDefinition nested = Generator.registerCXType(clang.clang_getArrayElementType((CXType)type), alternativeName, parent);
            typeDefinition.setOverrideMappedType(new PointerType(nested));
            typeDefinition.setNestedDefinition(nested);
            return typeDefinition;
        }
        if (typeKind.isStackElement()) {
            if (clang.clang_Location_isInSystemHeader((CXSourceLocation)clang.clang_getCursorLocation((CXCursor)clang.clang_getTypeDeclaration((CXType)type))) != 0) {
                TypeDefinition definition = TypeDefinition.get(TypeKind.VOID, "void");
                definition.setOverrideMappedType(new PrimitiveType(definition));
                return definition;
            }
            TypeDefinition typeDefinition = TypeDefinition.get(typeKind, name);
            typeDefinition.setAnonymous(clang.clang_Cursor_isAnonymous((CXCursor)clang.clang_getTypeDeclaration((CXType)type)) != 0);
            Manager.getInstance().registerCTypeMapping(name, typeDefinition);
            StackElementParser parser = new StackElementParser(typeDefinition, type, alternativeName, parent);
            typeDefinition.setOverrideMappedType(parser.getStackElementType());
            parser.parseMappedType();
            return typeDefinition;
        }
        if (typeKind == TypeKind.ENUM) {
            TypeDefinition typeDefinition = TypeDefinition.get(TypeKind.ENUM, name);
            Manager.getInstance().registerCTypeMapping(name, typeDefinition);
            typeDefinition.setNestedDefinition(Generator.registerCXType(clang.clang_getEnumDeclIntegerType((CXCursor)clang.clang_getTypeDeclaration((CXType)type)), null, null));
            typeDefinition.setOverrideMappedType(new EnumParser(typeDefinition, type, alternativeName).register());
            return typeDefinition;
        }
        throw new IllegalArgumentException("Should not reach");
    }

    public static void patchClosureTypeWithCursor(TypeDefinition definition, CXCursor cursor) {
        if (definition.getTypeKind() != TypeKind.CLOSURE) {
            throw new IllegalArgumentException("Can only reparse closures");
        }
        if (!(definition.getMappedType() instanceof ClosureType)) {
            throw new IllegalArgumentException("Can only reparse closures");
        }
        ClosureType closureType = (ClosureType)definition.getMappedType();
        CommentParser parser = new CommentParser(cursor);
        if (parser.isPresent()) {
            closureType.setComment(parser.parse());
        }
        Generator.patchSignatureArgNamesWithVisitor(closureType.getSignature(), cursor);
    }

    public static void patchSignatureArgNamesWithVisitor(final FunctionSignature functionSignature, CXCursor cursor) {
        final AtomicInteger counter = new AtomicInteger(0);
        CXCursorVisitor parameterVisitor = new CXCursorVisitor(){

            public int call(CXCursor current, CXCursor parent, CXClientData client_data) {
                if (current.kind() == 10) {
                    int id = counter.getAndIncrement();
                    String name = clang.clang_getCursorSpelling((CXCursor)current).getString();
                    if (name.isEmpty()) {
                        name = "arg" + id;
                    }
                    functionSignature.getArguments()[id].setName(name);
                }
                return 2;
            }
        };
        clang.clang_visitChildren((CXCursor)cursor, (CXCursorVisitor)parameterVisitor, null);
        parameterVisitor.close();
    }

    public static void dumpAST(CXCursor cursor, final int depth) {
        String indent = IntStream.range(0, depth).mapToObj(i -> " ").collect(Collectors.joining());
        System.out.printf("%s%s: %s (kind: %s)%n", indent, clang.clang_getCursorSpelling((CXCursor)cursor).getString(), clang.clang_getTypeSpelling((CXType)clang.clang_getCursorType((CXCursor)cursor)).getString(), clang.clang_getCursorKind((CXCursor)cursor));
        CXCursorVisitor visitor = new CXCursorVisitor(){

            public int call(CXCursor cursor, CXCursor parent, CXClientData client_data) {
                Generator.dumpAST(cursor, depth + 1);
                return 1;
            }
        };
        clang.clang_visitChildren((CXCursor)cursor, (CXCursorVisitor)visitor, null);
        visitor.close();
    }

    public static FunctionSignature parseFunctionSignature(String functionName, CXType functionType, CXCursor cursor) {
        if (clang.clang_isFunctionTypeVariadic((CXType)functionType) != 0) {
            throw new IllegalArgumentException("Function " + functionName + " is variadic, which is currently not supported");
        }
        CXType returnType = clang.clang_getResultType((CXType)functionType);
        TypeDefinition returnDefinition = Generator.registerCXType(returnType, "ret", null);
        int numArgs = clang.clang_getNumArgTypes((CXType)functionType);
        NamedType[] argTypes = new NamedType[numArgs];
        for (int i = 0; i < numArgs; ++i) {
            CXCursor paramCursor;
            String potentialName;
            CXType argType = clang.clang_getArgType((CXType)functionType, (int)i);
            if (clang.clang_getTypeSpelling((CXType)argType).getString().equals("va_list")) {
                throw new IllegalArgumentException("Function " + functionName + " has va_list parameter, which is currently not supported");
            }
            String name = "arg" + i;
            if (cursor != null && !(potentialName = clang.clang_getCursorSpelling((CXCursor)(paramCursor = clang.clang_Cursor_getArgument((CXCursor)cursor, (int)i))).getString()).isEmpty()) {
                name = potentialName;
            }
            TypeDefinition argTypeDefinition = Generator.registerCXType(argType, name, null);
            argTypes[i] = new NamedType(argTypeDefinition, name);
        }
        return new FunctionSignature(functionName, argTypes, returnDefinition);
    }

    public static void parse(String fileToParse, String[] options) {
        CXIndex index = clang.clang_createIndex((int)0, (int)1);
        BytePointer file = new BytePointer(Generator.createTempParsableFile(fileToParse).getAbsolutePath());
        String[] includePaths = ClangUtils.getIncludePaths();
        String[] parameter = new String[options.length + includePaths.length];
        System.arraycopy(includePaths, 0, parameter, 0, includePaths.length);
        System.arraycopy(options, 0, parameter, includePaths.length, options.length);
        PointerPointer argPointer = new PointerPointer(parameter);
        final CXTranslationUnit translationUnit = clang.clang_parseTranslationUnit((CXIndex)index, (BytePointer)file, (PointerPointer)argPointer, (int)parameter.length, null, (int)0, (int)4161);
        CXCursorVisitor visitor = new CXCursorVisitor(){

            public int call(@ByVal CXCursor current, @ByVal CXCursor parent, CXClientData cxClientData) {
                CXSourceLocation location = clang.clang_getCursorLocation((CXCursor)current);
                if (clang.clang_Location_isInSystemHeader((CXSourceLocation)location) != 0) {
                    return 1;
                }
                String name = clang.clang_getCursorSpelling((CXCursor)current).getString();
                if (current.kind() == 8) {
                    CXType funcType = clang.clang_getCursorType((CXCursor)current);
                    try {
                        Manager.startNewManager();
                        FunctionSignature functionSignature = Generator.parseFunctionSignature(name, funcType, current);
                        Manager.getInstance().addFunction(new FunctionType(functionSignature, new CommentParser(current).parse()));
                    }
                    catch (Throwable e) {
                        Manager.rollBack();
                        System.err.println("Failed to parse function: " + name);
                        e.printStackTrace();
                    }
                } else if (current.kind() == 501 && clang.clang_Cursor_isMacroBuiltin((CXCursor)current) == 0 && clang.clang_Cursor_isMacroFunctionLike((CXCursor)current) == 0) {
                    CXSourceRange range = clang.clang_getCursorExtent((CXCursor)current);
                    CXToken tokens = new CXToken(null);
                    IntPointer nTokens = new IntPointer(1L);
                    clang.clang_tokenize((CXTranslationUnit)translationUnit, (CXSourceRange)range, (CXToken)tokens, (IntPointer)nTokens);
                    String tokenizedName = clang.clang_getTokenSpelling((CXTranslationUnit)translationUnit, (CXToken)tokens.position(0L)).getString();
                    StringBuilder value = new StringBuilder();
                    for (int i = 1; i < nTokens.get(); ++i) {
                        value.append(clang.clang_getTokenSpelling((CXTranslationUnit)translationUnit, (CXToken)tokens.position((long)i)).getString());
                    }
                    Manager.getInstance().registerMacro(new MacroType(tokenizedName, value.toString(), null));
                }
                return 2;
            }
        };
        clang.clang_visitChildren((CXCursor)clang.clang_getTranslationUnitCursor((CXTranslationUnit)translationUnit), (CXCursorVisitor)visitor, null);
        argPointer.close();
        file.close();
        clang.clang_disposeTranslationUnit((CXTranslationUnit)translationUnit);
        clang.clang_disposeIndex((CXIndex)index);
    }

    public static void generateJavaCode(String path) {
        Manager.getInstance().emit(path);
    }

    public static void execute(String path, String basePackage, String fileToParse, String[] options) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        String[] extendedOptions = Arrays.copyOf(options, options.length + 2);
        extendedOptions[extendedOptions.length - 2] = "-m32";
        extendedOptions[extendedOptions.length - 1] = "-funsigned-char";
        Manager.init(fileToParse, basePackage);
        Generator.parse(fileToParse, extendedOptions);
        Manager unsignedCharManager = Manager.getInstance();
        extendedOptions = Arrays.copyOf(options, options.length + 1);
        extendedOptions[extendedOptions.length - 1] = "-fsigned-char";
        Manager.init(fileToParse, basePackage);
        Generator.parse(fileToParse, extendedOptions);
        Manager.getInstance().mergeManager(unsignedCharManager);
        Generator.generateJavaCode(path);
    }

    public static void main(String[] args) {
        String[] options = new String[args.length - 3];
        System.arraycopy(args, 3, options, 0, options.length);
        Generator.execute(args[0], args[1], args[2], options);
    }
}

