/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.generator;

import com.badlogic.gdx.jnigen.generator.PossibleTarget;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.expr.ConditionalExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class JavaUtils {
    public static String getGetter(String name) {
        String firstLetterUpperCase = name.substring(0, 1).toUpperCase() + name.substring(1);
        return "get" + firstLetterUpperCase;
    }

    public static String getSetter(String name) {
        String firstLetterUpperCase = name.substring(0, 1).toUpperCase() + name.substring(1);
        return "set" + firstLetterUpperCase;
    }

    public static String cNameToJavaTypeName(String name) {
        return name.replace("struct ", "").replace("union ", "").replace("enum ", "").replace("const ", "");
    }

    public static String capitalize(String toCapitalize) {
        return toCapitalize.substring(0, 1).toUpperCase() + toCapitalize.substring(1);
    }

    public static String javarizeName(String cName) {
        int index;
        cName = JavaUtils.capitalize(cName);
        while ((index = cName.indexOf(95)) != -1) {
            cName = cName.substring(0, index) + JavaUtils.capitalize(cName.substring(index + 1));
        }
        return cName;
    }

    public static Expression getOffsetAsExpression(int index, OffsetCalculator calculator) {
        return JavaUtils.getSizeAsExpression(target -> calculator.getOffset(index, target));
    }

    public static String findShortcutExpression(List<PossibleTarget> smallerGroup) {
        if (smallerGroup.size() == 1) {
            return smallerGroup.get(0).javaCondition();
        }
        if (smallerGroup.equals(Arrays.asList(PossibleTarget.UNIX_64, PossibleTarget.WIN_64))) {
            return "CHandler.IS_64_BIT";
        }
        if (smallerGroup.equals(Arrays.asList(PossibleTarget.WIN_64, PossibleTarget.UNIX_64))) {
            return "CHandler.IS_64_BIT";
        }
        return "(" + smallerGroup.stream().map(PossibleTarget::javaCondition).collect(Collectors.joining(" || ")) + ")";
    }

    public static Expression getSizeAsExpression(SizeCalculator calculator) {
        Map<Integer, List<PossibleTarget>> offsetGroups = Arrays.stream(PossibleTarget.values()).collect(Collectors.groupingBy(calculator::getOffset));
        if (offsetGroups.size() == 1) {
            return new IntegerLiteralExpr(String.valueOf(calculator.getOffset(PossibleTarget.UNIX_64)));
        }
        if (offsetGroups.size() == 2) {
            List smallerGroup = offsetGroups.values().stream().min(Comparator.comparing(List::size)).get();
            List bigger = offsetGroups.values().stream().max(Comparator.comparing(List::size)).get();
            int sizeSmaller = calculator.getOffset((PossibleTarget)((Object)smallerGroup.get(0)));
            int sizeBigger = calculator.getOffset((PossibleTarget)((Object)bigger.get(0)));
            String expr = JavaUtils.findShortcutExpression(smallerGroup);
            return StaticJavaParser.parseExpression((String)(expr + " ? " + sizeSmaller + " : " + sizeBigger));
        }
        List sortedGroups = offsetGroups.entrySet().stream().sorted(Comparator.comparing(entry -> ((List)entry.getValue()).size())).collect(Collectors.toList());
        int defaultOffset = (Integer)((Map.Entry)sortedGroups.get(sortedGroups.size() - 1)).getKey();
        IntegerLiteralExpr result = new IntegerLiteralExpr(String.valueOf(defaultOffset));
        for (int i = sortedGroups.size() - 2; i >= 0; --i) {
            Map.Entry currentGroup = (Map.Entry)sortedGroups.get(i);
            int currentOffset = (Integer)currentGroup.getKey();
            List currentTargets = (List)currentGroup.getValue();
            String condition = currentTargets.stream().map(PossibleTarget::javaCondition).collect(Collectors.joining(" || "));
            Expression conditionExpr = StaticJavaParser.parseExpression((String)("(" + condition + ")"));
            IntegerLiteralExpr thenExpr = new IntegerLiteralExpr(String.valueOf(currentOffset));
            result = new ConditionalExpr(conditionExpr, (Expression)thenExpr, (Expression)result);
        }
        return result;
    }

    @FunctionalInterface
    public static interface OffsetCalculator {
        public int getOffset(int var1, PossibleTarget var2);
    }

    @FunctionalInterface
    public static interface SizeCalculator {
        public int getOffset(PossibleTarget var1);
    }
}

