/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.generator;

import com.badlogic.gdx.jnigen.generator.JavaUtils;
import com.badlogic.gdx.jnigen.generator.PossibleTarget;
import com.badlogic.gdx.jnigen.generator.types.ClosureType;
import com.badlogic.gdx.jnigen.generator.types.EnumType;
import com.badlogic.gdx.jnigen.generator.types.FunctionType;
import com.badlogic.gdx.jnigen.generator.types.GlobalType;
import com.badlogic.gdx.jnigen.generator.types.MacroType;
import com.badlogic.gdx.jnigen.generator.types.StackElementType;
import com.badlogic.gdx.jnigen.generator.types.TypeDefinition;
import com.badlogic.gdx.jnigen.generator.types.TypeKind;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.comments.BlockComment;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.printer.configuration.ConfigurationOption;
import com.github.javaparser.printer.configuration.DefaultConfigurationOption;
import com.github.javaparser.printer.configuration.DefaultPrinterConfiguration;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Manager {
    public static final int VOID_FFI_ID = -2;
    public static final int POINTER_FFI_ID = -1;
    private static Manager instance;
    private final Manager rollBackManager;
    private final String parsedCHeader;
    private final String basePackage;
    private final Map<String, StackElementType> stackElements = new HashMap<String, StackElementType>();
    private final ArrayList<StackElementType> orderedStackElements = new ArrayList();
    private final Map<String, EnumType> enums = new HashMap<String, EnumType>();
    private final HashMap<String, TypeDefinition> knownCTypes = new HashMap();
    private final HashMap<String, TypeDefinition> cTypeToJavaStringMapper = new HashMap();
    private final Map<String, String> typedefs = new HashMap<String, String>();
    private final Map<String, MacroType> macros = new HashMap<String, MacroType>();
    private final GlobalType globalType;

    public static void init(String parsedCHeader, String basePackage) {
        instance = new Manager(parsedCHeader, basePackage);
    }

    public Manager(String parsedCHeader, String basePackage) {
        this.rollBackManager = null;
        this.parsedCHeader = parsedCHeader;
        this.basePackage = basePackage;
        String[] segments = parsedCHeader.split("/");
        this.globalType = new GlobalType(JavaUtils.javarizeName(segments[segments.length - 1].split("\\.h")[0]));
    }

    public Manager(Manager rollBackManager) {
        this.rollBackManager = rollBackManager;
        this.parsedCHeader = rollBackManager.parsedCHeader;
        this.basePackage = rollBackManager.basePackage;
        this.stackElements.putAll(rollBackManager.stackElements);
        this.orderedStackElements.addAll(rollBackManager.orderedStackElements);
        this.enums.putAll(rollBackManager.enums);
        this.knownCTypes.putAll(rollBackManager.knownCTypes);
        this.cTypeToJavaStringMapper.putAll(rollBackManager.cTypeToJavaStringMapper);
        this.typedefs.putAll(rollBackManager.typedefs);
        this.macros.putAll(rollBackManager.macros);
        this.globalType = rollBackManager.globalType.duplicate();
    }

    public static void startNewManager() {
        instance = new Manager(instance);
    }

    public static void rollBack() {
        if (Manager.instance.rollBackManager == null) {
            throw new IllegalStateException("Can't rollback, because no rollback point exists");
        }
        instance = Manager.instance.rollBackManager;
    }

    public void mergeManager(Manager toMerge) {
        toMerge.knownCTypes.forEach((name, typeDefinition) -> {
            TypeDefinition own = this.knownCTypes.get(name);
            if (own == null) {
                throw new IllegalStateException("Can't merge Manager cause " + name + " doesn't exist in both.");
            }
            if (own.getTypeKind() != typeDefinition.getTypeKind()) {
                if (own.getTypeKind() == TypeKind.SIGNED_BYTE && typeDefinition.getTypeKind() == TypeKind.PROMOTED_BYTE) {
                    own.setTypeKind(TypeKind.NATIVE_BYTE);
                } else if (own.getTypeKind() == TypeKind.PROMOTED_LONG && typeDefinition.getTypeKind() == TypeKind.PROMOTED_LONG_LONG) {
                    own.setTypeKind(TypeKind.PROMOTED_LONG_LONG);
                } else if (own.getTypeKind() == TypeKind.LONG && typeDefinition.getTypeKind() == TypeKind.LONG_LONG) {
                    own.setTypeKind(TypeKind.LONG_LONG);
                } else {
                    throw new IllegalStateException("Can't merge " + (Object)((Object)typeDefinition.getTypeKind()) + " into " + (Object)((Object)own.getTypeKind()));
                }
            }
        });
    }

    public void addStackElement(StackElementType stackElementType, boolean registerGlobally) {
        String name = stackElementType.abstractType();
        if (registerGlobally) {
            if (this.stackElements.containsKey(name)) {
                throw new IllegalArgumentException("Struct with name: " + name + " already exists.");
            }
            this.stackElements.put(name, stackElementType);
        }
        this.orderedStackElements.add(stackElementType);
        this.orderedStackElements.sort(Comparator.comparing(StackElementType::abstractType));
    }

    public int getStackElementID(StackElementType stackElementType) {
        return this.orderedStackElements.indexOf(stackElementType) + this.knownCTypes.size();
    }

    public void addEnum(EnumType enumType) {
        String name = enumType.abstractType();
        if (this.enums.containsKey(name)) {
            throw new IllegalArgumentException("Enum with name: " + name + " already exists.");
        }
        this.enums.put(name, enumType);
    }

    public void recordCType(String name, TypeDefinition definition) {
        if (this.hasCType(name)) {
            throw new IllegalArgumentException("CType with name: " + name + " already exists");
        }
        this.knownCTypes.put(name, definition);
    }

    public boolean hasCType(String name) {
        return this.knownCTypes.containsKey(name);
    }

    public TypeDefinition getCType(String name) {
        return this.knownCTypes.get(name);
    }

    public int getCTypeID(String name) {
        List cTypes = this.knownCTypes.keySet().stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        if (!cTypes.contains(name)) {
            throw new IllegalArgumentException("CType " + name + " is not registered.");
        }
        return cTypes.indexOf(name);
    }

    public void registerMacro(MacroType macroType) {
        if (this.macros.containsKey(macroType.getName()) && !this.macros.get(macroType.getName()).getValue().equals(macroType.getValue())) {
            throw new IllegalArgumentException("Macro with name " + macroType.getName() + " already exists, but has different value. Old: " + this.macros.get(macroType.getName()).getValue() + " != New: " + macroType.getValue());
        }
        this.macros.put(macroType.getName(), macroType);
    }

    public void registerCTypeMapping(String name, TypeDefinition javaRepresentation) {
        if (this.cTypeToJavaStringMapper.containsKey(name)) {
            throw new IllegalArgumentException("Already registered type " + name);
        }
        this.cTypeToJavaStringMapper.put(name, javaRepresentation);
    }

    private TypeDefinition getCTypeMapping(String name) {
        if (this.cTypeToJavaStringMapper.containsKey(name)) {
            return this.cTypeToJavaStringMapper.get(name);
        }
        if (this.typedefs.containsKey(name)) {
            return this.getCTypeMapping(this.typedefs.get(name));
        }
        return null;
    }

    public TypeDefinition resolveCTypeMapping(String name) {
        if (!this.hasCTypeMapping(name)) {
            throw new IllegalArgumentException("No registered type " + name);
        }
        return this.getCTypeMapping(name);
    }

    public boolean hasCTypeMapping(String name) {
        return this.getCTypeMapping(name) != null;
    }

    public boolean hasFunctionWithName(String name) {
        return this.globalType.getFunctions().stream().anyMatch(functionType -> functionType.getSignature().getName().equals(name));
    }

    public void addClosure(ClosureType closureType) {
        this.globalType.addClosure(closureType);
    }

    public void registerTypeDef(String typedef, String name) {
        if (this.typedefs.containsKey(typedef) && !this.typedefs.get(typedef).equals(name)) {
            throw new IllegalArgumentException("Typedef " + typedef + " already exists");
        }
        this.typedefs.put(typedef, name);
    }

    public void addFunction(FunctionType functionType) {
        this.globalType.addFunction(functionType);
    }

    public GlobalType getGlobalType() {
        return this.globalType;
    }

    public String getParsedCHeader() {
        return this.parsedCHeader;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public String patchMethodNative(MethodDeclaration method, String nativeCode, String classString) {
        String methodString = method.toString(new DefaultPrinterConfiguration().removeOption((ConfigurationOption)new DefaultConfigurationOption(DefaultPrinterConfiguration.ConfigOption.PRINT_COMMENTS)));
        String lineToPatch = Arrays.stream(classString.split("\r\n|\n")).filter(line -> line.contains(methodString)).findFirst().orElse(null);
        if (lineToPatch == null) {
            throw new IllegalArgumentException("Failed to find native method: " + method + " in " + classString);
        }
        String offset = lineToPatch.replace(lineToPatch.trim(), "");
        String newLine = lineToPatch + "/*\n";
        newLine = newLine + Arrays.stream(nativeCode.split("\r\n|\n")).map(s -> offset + "\t" + s).collect(Collectors.joining("\n"));
        newLine = newLine + "\n" + offset + "*/";
        return classString.replace(lineToPatch, newLine);
    }

    private void addJNIComment(ClassOrInterfaceDeclaration toAddTo, String ... content) {
        StringBuilder result = new StringBuilder("JNI\n");
        for (String line : content) {
            result.append("\t\t").append(line).append("\n");
        }
        toAddTo.addOrphanComment((Comment)new BlockComment(result.toString()));
    }

    private void createStaticAsserts(List<String> assertBuilder, PossibleTarget target) {
        assertBuilder.add("#if " + target.condition());
        this.knownCTypes.forEach((name, typeKind) -> {
            assertBuilder.add("static_assert(sizeof(" + name + ") == " + typeKind.getMappedType().getSize(target) + ", \"Type " + name + " has unexpected size.\");");
            assertBuilder.add("static_assert(alignof(" + name + ") == " + typeKind.getMappedType().getAlignment(target) + ", \"Type " + name + " has unexpected alignment.\");");
        });
        this.stackElements.forEach((name, stackElementType) -> {
            if (stackElementType.getFields().isEmpty()) {
                return;
            }
            assertBuilder.add("static_assert(sizeof(" + name + ") == " + stackElementType.getSize(target) + ", \"Type " + name + " has unexpected size.\");");
            assertBuilder.add("static_assert(alignof(" + name + ") == " + stackElementType.getAlignment(target) + ", \"Type " + name + " has unexpected alignment.\");");
            for (int i = 0; i < stackElementType.getFields().size(); ++i) {
                assertBuilder.add("static_assert(offsetof(" + name + ", " + stackElementType.getFields().get(i).getName() + ") == " + stackElementType.getFieldOffset(i, target) + ", \"Type " + name + " has unexpected offset.\");");
            }
        });
        assertBuilder.add("#endif // " + target.condition());
    }

    public void emit(String basePath) {
        try {
            int i;
            Object cu;
            CompilationUnit globalCU = new CompilationUnit(this.globalType.packageName());
            CompilationUnit globalCUInternal = new CompilationUnit(this.globalType.packageName());
            ClassOrInterfaceDeclaration global = globalCU.addClass(this.globalType.abstractType(), new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.FINAL});
            ClassOrInterfaceDeclaration globalInternal = globalCUInternal.addClass(this.globalType.internalClassName(), new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.FINAL});
            for (StackElementType stackElementType : this.stackElements.values()) {
                cu = new CompilationUnit(stackElementType.packageName());
                ClassOrInterfaceDeclaration classOrInterfaceDeclaration = stackElementType.generateClass();
                cu.addType((TypeDeclaration)classOrInterfaceDeclaration);
                ClassOrInterfaceDeclaration declarationInternal = stackElementType.generateClassInternal();
                globalInternal.addMember((BodyDeclaration)declarationInternal);
                stackElementType.write((CompilationUnit)cu, classOrInterfaceDeclaration, globalCUInternal, declarationInternal);
                String classContent = cu.toString();
                String fullPath = basePath + stackElementType.classFile().replace(".", "/") + ".java";
                PossibleTarget[] structPath = Paths.get(fullPath, new String[0]);
                structPath.getParent().toFile().mkdirs();
                Files.write((Path)structPath, classContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            for (EnumType enumType : this.enums.values()) {
                cu = new CompilationUnit(enumType.packageName());
                enumType.write((CompilationUnit)cu);
                String string = basePath + enumType.classFile().replace(".", "/") + ".java";
                Path structPath = Paths.get(string, new String[0]);
                structPath.getParent().toFile().mkdirs();
                Files.write(structPath, cu.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            HashMap<MethodDeclaration, String> patchGlobalMethods = new HashMap<MethodDeclaration, String>();
            this.globalType.write(globalCU, global, globalCUInternal, globalInternal, patchGlobalMethods);
            String globalFile = globalCU.toString();
            for (Map.Entry entry : patchGlobalMethods.entrySet()) {
                MethodDeclaration methodDeclaration = (MethodDeclaration)entry.getKey();
                String s = (String)entry.getValue();
                globalFile = this.patchMethodNative(methodDeclaration, s, globalFile);
            }
            Files.write(Paths.get(basePath + this.globalType.classFile().replace(".", "/") + ".java", new String[0]), globalFile.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Files.write(Paths.get(basePath + this.globalType.classFile().replace(".", "/") + "_Internal.java", new String[0]), globalCUInternal.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            CompilationUnit constantsCU = new CompilationUnit(this.basePackage);
            ClassOrInterfaceDeclaration classOrInterfaceDeclaration = constantsCU.addClass("Constants", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.FINAL});
            this.macros.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparing(MacroType::getName))).forEach(macroType -> ((MacroType)macroType.getValue()).write(constantsCU, constantsClass));
            Files.write(Paths.get(basePath + this.basePackage.replace(".", "/") + "/Constants.java", new String[0]), constantsCU.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            CompilationUnit ffiTypeCU = new CompilationUnit(this.basePackage);
            ffiTypeCU.addImport("com.badlogic.gdx.jnigen.runtime.CHandler");
            ffiTypeCU.addImport("com.badlogic.gdx.jnigen.runtime.c.CTypeInfo");
            ClassOrInterfaceDeclaration ffiTypeClass = ffiTypeCU.addClass("FFITypes", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
            this.addJNIComment(ffiTypeClass, "#include <jnigen.h>", "#include <" + this.parsedCHeader + ">");
            ArrayList<String> assertBuilder = new ArrayList<String>();
            assertBuilder.add("#if " + PossibleTarget.unsupportedPlatformCondition());
            assertBuilder.add("\t#error Unsupported OS/Platform");
            assertBuilder.add("#endif");
            assertBuilder.add("\n");
            for (PossibleTarget target : PossibleTarget.values()) {
                this.createStaticAsserts(assertBuilder, target);
                assertBuilder.add("\n");
            }
            this.knownCTypes.forEach((name, typeKind) -> {
                if (typeKind.getTypeKind() == TypeKind.NATIVE_BYTE) {
                    return;
                }
                if (typeKind.getTypeKind().isSigned()) {
                    assertBuilder.add("static_assert(IS_SIGNED_TYPE(" + name + "), \"Type " + name + " is expected signed.\");");
                } else {
                    assertBuilder.add("static_assert(IS_UNSIGNED_TYPE(" + name + "), \"Type " + name + " is expected unsigned.\");");
                }
            });
            this.addJNIComment(ffiTypeClass, assertBuilder.toArray(new String[0]));
            ffiTypeClass.addMethod("init", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.STATIC});
            ffiTypeCU.addImport(HashMap.class);
            ffiTypeClass.addFieldWithInitializer("HashMap<Integer, CTypeInfo>", "ffiIdMap", StaticJavaParser.parseExpression((String)"new HashMap<>()"), new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.FINAL, Modifier.Keyword.STATIC});
            ((MethodDeclaration)((MethodDeclaration)ffiTypeClass.addMethod("getCTypeInfo", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.STATIC}).setType("CTypeInfo")).addParameter(Integer.TYPE, "id")).createBody().addStatement("return ffiIdMap.get(id);");
            BlockComment getFFITypeNativeMethod = new BlockComment();
            ffiTypeClass.addOrphanComment((Comment)getFFITypeNativeMethod);
            String nativeGetFFIMethodName = "getNativeType";
            MethodDeclaration getFFITypeMethod = ffiTypeClass.addMethod("getNativeType", new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.NATIVE, Modifier.Keyword.STATIC});
            ((MethodDeclaration)getFFITypeMethod.setBody(null).setType(Long.TYPE)).addParameter(Integer.TYPE, "id");
            StringBuilder ffiTypeNativeBody = new StringBuilder("JNI\n");
            ffiTypeNativeBody.append("static native_type* ").append(nativeGetFFIMethodName).append("(int id) {\n");
            ffiTypeNativeBody.append("native_type* nativeType = (native_type*)malloc(sizeof(native_type));\n");
            ffiTypeNativeBody.append("switch(id) {\n");
            BlockStmt staticInit = ffiTypeClass.addStaticInitializer();
            ffiTypeNativeBody.append("\tcase ").append(-2).append(":\n").append("\t\t").append("nativeType->type = VOID_TYPE;").append("\n").append("\t\treturn nativeType;\n");
            staticInit.addStatement("ffiIdMap.put(-2, CHandler.constructCTypeFromNativeType(getNativeType(-2)));");
            ffiTypeNativeBody.append("\tcase ").append(-1).append(":\n").append("\t\t").append("nativeType->type = POINTER_TYPE;").append("\n").append("\t\treturn nativeType;\n");
            staticInit.addStatement("ffiIdMap.put(-1, CHandler.constructCTypeFromNativeType(getNativeType(-1)));");
            List cTypes = this.knownCTypes.keySet().stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
            for (i = 0; i < cTypes.size(); ++i) {
                String cType = (String)cTypes.get(i);
                staticInit.addStatement("ffiIdMap.put(" + i + ", CHandler.constructCTypeFromNativeType(getNativeType(" + i + ")));");
                ffiTypeNativeBody.append("\tcase ").append(i).append(":\n");
                ffiTypeNativeBody.append("\t\tGET_NATIVE_TYPE(").append(cType).append(", nativeType);\n");
                ffiTypeNativeBody.append("\t\treturn nativeType;\n");
            }
            for (i = 0; i < this.orderedStackElements.size(); ++i) {
                int id = i + this.knownCTypes.size();
                StackElementType stackElementType = this.orderedStackElements.get(i);
                staticInit.addStatement("ffiIdMap.put(" + id + ", CHandler.constructCTypeFromNativeType(getNativeType(" + id + ")));");
                ffiTypeNativeBody.append("\tcase ").append(id).append(":\n");
                ffiTypeNativeBody.append(stackElementType.getFFITypeBody(nativeGetFFIMethodName));
            }
            ffiTypeNativeBody.append("\tdefault:\n\t\treturn NULL;\n");
            ffiTypeNativeBody.append("\t}\n}\n");
            getFFITypeNativeMethod.setContent(ffiTypeNativeBody.toString());
            String jniMethodBody = "return reinterpret_cast<jlong>(" + nativeGetFFIMethodName + "(id));\n";
            String ffiTypeString = ffiTypeCU.toString();
            ffiTypeString = this.patchMethodNative(getFFITypeMethod, jniMethodBody, ffiTypeString);
            Files.write(Paths.get(basePath + this.basePackage.replace(".", "/") + "/FFITypes.java", new String[0]), ffiTypeString.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Manager getInstance() {
        return instance;
    }
}

