/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.generator.parser;

import com.badlogic.gdx.jnigen.generator.JavaUtils;
import com.badlogic.gdx.jnigen.generator.Manager;
import com.badlogic.gdx.jnigen.generator.parser.CommentParser;
import com.badlogic.gdx.jnigen.generator.types.EnumConstant;
import com.badlogic.gdx.jnigen.generator.types.EnumType;
import com.badlogic.gdx.jnigen.generator.types.MappedType;
import com.badlogic.gdx.jnigen.generator.types.TypeDefinition;
import org.bytedeco.llvm.clang.CXClientData;
import org.bytedeco.llvm.clang.CXCursor;
import org.bytedeco.llvm.clang.CXCursorVisitor;
import org.bytedeco.llvm.clang.CXType;
import org.bytedeco.llvm.global.clang;

public class EnumParser {
    private final TypeDefinition definition;
    private final CXType toParse;
    private final String alternativeName;

    public EnumParser(TypeDefinition definition, CXType toParse, String alternativeName) {
        this.toParse = toParse;
        this.alternativeName = alternativeName;
        this.definition = definition;
    }

    public MappedType register() {
        String name = clang.clang_getTypeSpelling((CXType)this.toParse).getString();
        String javaName = clang.clang_Cursor_isAnonymous((CXCursor)clang.clang_getTypeDeclaration((CXType)this.toParse)) == 0 ? JavaUtils.cNameToJavaTypeName(name) : this.alternativeName;
        CXCursor cursor = clang.clang_getTypeDeclaration((CXType)this.toParse);
        final EnumType enumType = new EnumType(this.definition, javaName);
        CommentParser commentParser = new CommentParser(cursor);
        if (commentParser.isPresent()) {
            enumType.setComment(commentParser.parse());
        }
        CXCursorVisitor visitor = new CXCursorVisitor(){

            public int call(CXCursor current, CXCursor parent, CXClientData cxClientData) {
                String cursorSpelling = clang.clang_getCursorSpelling((CXCursor)current).getString();
                if (current.kind() == 7) {
                    long constantValue = clang.clang_getEnumConstantDeclValue((CXCursor)current);
                    if (constantValue > Integer.MAX_VALUE || constantValue < Integer.MIN_VALUE) {
                        throw new IllegalArgumentException("Why is the enum " + enumType.abstractType() + " so biiig? Please open a issue in the gdx-jnigen repo");
                    }
                    EnumConstant constant = new EnumConstant((int)constantValue, cursorSpelling, new CommentParser(current).parse());
                    enumType.registerConstant(constant);
                }
                return 2;
            }
        };
        clang.clang_visitChildren((CXCursor)cursor, (CXCursorVisitor)visitor, null);
        visitor.close();
        Manager.getInstance().addEnum(enumType);
        return enumType;
    }
}

