/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.generator.parser;

import com.badlogic.gdx.jnigen.generator.Generator;
import com.badlogic.gdx.jnigen.generator.JavaUtils;
import com.badlogic.gdx.jnigen.generator.Manager;
import com.badlogic.gdx.jnigen.generator.parser.CommentParser;
import com.badlogic.gdx.jnigen.generator.types.MappedType;
import com.badlogic.gdx.jnigen.generator.types.NamedType;
import com.badlogic.gdx.jnigen.generator.types.StackElementField;
import com.badlogic.gdx.jnigen.generator.types.StackElementType;
import com.badlogic.gdx.jnigen.generator.types.TypeDefinition;
import com.badlogic.gdx.jnigen.generator.types.TypeKind;
import org.bytedeco.llvm.clang.CXClientData;
import org.bytedeco.llvm.clang.CXCursor;
import org.bytedeco.llvm.clang.CXCursorVisitor;
import org.bytedeco.llvm.clang.CXType;
import org.bytedeco.llvm.global.clang;

public class StackElementParser {
    private final TypeDefinition typeDefinition;
    private final CXType toParse;
    private final String alternativeName;
    private final StackElementType stackElementType;
    private MappedType parent;

    public StackElementParser(TypeDefinition typeDefinition, CXType toParse, String alternativeName, MappedType parent) {
        this.typeDefinition = typeDefinition;
        this.toParse = toParse;
        this.alternativeName = alternativeName;
        this.parent = parent;
        this.stackElementType = this.constructMappedType();
    }

    private StackElementType constructMappedType() {
        String javaName;
        String name = clang.clang_getTypeSpelling((CXType)this.toParse).getString();
        if (!this.typeDefinition.isAnonymous()) {
            this.parent = null;
            javaName = JavaUtils.cNameToJavaTypeName(name);
        } else {
            javaName = this.alternativeName;
        }
        StackElementType type = new StackElementType(this.typeDefinition, javaName, this.parent);
        Manager.getInstance().addStackElement(type, this.parent == null);
        return type;
    }

    public StackElementType getStackElementType() {
        return this.stackElementType;
    }

    public void parseMappedType() {
        CXCursor cursor = clang.clang_getTypeDeclaration((CXType)this.toParse);
        CommentParser commentParser = new CommentParser(cursor);
        if (commentParser.isPresent()) {
            this.stackElementType.setComment(commentParser.parse());
        }
        CXCursorVisitor visitor = new CXCursorVisitor(){
            private CXType anonymousType;

            private void parseAnonymousType() {
                CXCursor anonymousCursor = clang.clang_getTypeDeclaration((CXType)this.anonymousType);
                this.anonymousType = null;
                clang.clang_visitChildren((CXCursor)anonymousCursor, (CXCursorVisitor)this, null);
                if (this.anonymousType != null) {
                    this.parseAnonymousType();
                }
            }

            public void close() {
                if (this.anonymousType != null) {
                    this.parseAnonymousType();
                }
                super.close();
            }

            public int call(CXCursor current, CXCursor parent, CXClientData cxClientData) {
                String cursorSpelling = clang.clang_getCursorSpelling((CXCursor)current).getString();
                if (current.kind() == 6) {
                    TypeDefinition fieldDefinition;
                    CXType type = clang.clang_getCursorType((CXCursor)current);
                    if (this.anonymousType != null) {
                        CXType resolvedType = type;
                        if (resolvedType.kind() == 112) {
                            resolvedType = clang.clang_getArrayElementType((CXType)resolvedType);
                        }
                        if (clang.clang_equalTypes((CXType)(resolvedType = clang.clang_getCursorType((CXCursor)clang.clang_getTypeDeclaration((CXType)resolvedType))), (CXType)this.anonymousType) == 0) {
                            this.parseAnonymousType();
                        }
                        this.anonymousType = null;
                    }
                    if ((fieldDefinition = Generator.registerCXType(type, cursorSpelling, StackElementParser.this.stackElementType)).getTypeKind() == TypeKind.CLOSURE) {
                        Generator.patchClosureTypeWithCursor(fieldDefinition, current);
                    }
                    NamedType namedType = new NamedType(fieldDefinition, cursorSpelling);
                    StackElementField field = new StackElementField(namedType, new CommentParser(current).parse());
                    StackElementParser.this.stackElementType.addField(field);
                    while (fieldDefinition.getNestedDefinition() != null) {
                        fieldDefinition = fieldDefinition.getNestedDefinition();
                    }
                    if (fieldDefinition.isAnonymous()) {
                        StackElementParser.this.stackElementType.addChild(fieldDefinition);
                    }
                } else if (current.kind() == 2 || current.kind() == 3) {
                    if (this.anonymousType != null) {
                        this.parseAnonymousType();
                    }
                    if (clang.clang_Cursor_isAnonymous((CXCursor)current) != 0) {
                        this.anonymousType = clang.clang_getCursorType((CXCursor)current);
                    }
                }
                return 1;
            }
        };
        clang.clang_visitChildren((CXCursor)cursor, (CXCursorVisitor)visitor, null);
        visitor.close();
    }
}

