/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.generator.types;

import com.badlogic.gdx.jnigen.generator.JavaUtils;
import com.badlogic.gdx.jnigen.generator.PossibleTarget;
import com.badlogic.gdx.jnigen.generator.types.FunctionSignature;
import com.badlogic.gdx.jnigen.generator.types.MappedType;
import com.badlogic.gdx.jnigen.generator.types.NamedType;
import com.badlogic.gdx.jnigen.generator.types.TypeDefinition;
import com.badlogic.gdx.jnigen.generator.types.TypeKind;
import com.badlogic.gdx.jnigen.generator.types.WritableClass;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.UnknownType;
import java.util.Arrays;

public class ClosureType
implements MappedType,
WritableClass {
    private final FunctionSignature signature;
    private final MappedType parent;
    private String comment;

    public ClosureType(FunctionSignature signature, MappedType parent) {
        this.signature = signature;
        this.parent = parent;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public ClassOrInterfaceDeclaration generateClass() {
        return (ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)new ClassOrInterfaceDeclaration().setInterface(true).addExtendedType("Closure")).addExtendedType(this.internalClassName())).setModifier(Modifier.Keyword.PUBLIC, true)).setName(this.signature.getName());
    }

    @Override
    public ClassOrInterfaceDeclaration generateClassInternal() {
        return (ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)((ClassOrInterfaceDeclaration)new ClassOrInterfaceDeclaration().setInterface(true).addExtendedType("Closure")).setModifier(Modifier.Keyword.PUBLIC, true)).setName(this.internalClassName());
    }

    public void writeHelper(CompilationUnit cu, ClassOrInterfaceDeclaration closureHelperClass) {
        cu.addImport(this.classFile() + "." + this.signature.getName());
        cu.addImport("com.badlogic.gdx.jnigen.runtime.closure.ClosureEncoder");
        cu.addImport("com.badlogic.gdx.jnigen.runtime.closure.CClosureObject");
        MethodDeclaration downcallMethod = closureHelperClass.addMethod(this.getName() + "_downcall", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.STATIC});
        downcallMethod.addParameter(Long.TYPE, "fnPtr");
        downcallMethod.setType("CClosureObject<" + this.getName() + ">");
        BlockStmt stmt = downcallMethod.createBody();
        VariableDeclarationExpr encoderDeclaration = new VariableDeclarationExpr(((VariableDeclarator)((VariableDeclarator)new VariableDeclarator().setType("ClosureEncoder")).setName("encoder")).setInitializer((Expression)((ObjectCreationExpr)((ObjectCreationExpr)new ObjectCreationExpr().setType("ClosureEncoder")).addArgument((Expression)new NameExpr("fnPtr"))).addArgument((Expression)new NameExpr("__ffi_cache"))));
        VariableDeclarationExpr useEncoderDeclaration = new VariableDeclarationExpr(((VariableDeclarator)((VariableDeclarator)new VariableDeclarator().setType("BufferPtr")).setName("bufPtr")).setInitializer((Expression)new MethodCallExpr((Expression)new NameExpr("encoder"), "lockOrDuplicate")));
        NodeList arguments = new NodeList();
        for (int i = 0; i < this.signature.getArguments().length; ++i) {
            NamedType argument = this.signature.getArguments()[i];
            Expression writeArgExpr = argument.getDefinition().getMappedType().writeToBufferPtr((Expression)new NameExpr("bufPtr"), JavaUtils.getOffsetAsExpression(i, this::getParameterOffset), argument.getDefinition().getMappedType().toC((Expression)new NameExpr(argument.getName())));
            arguments.add((Node)new ExpressionStmt(writeArgExpr));
        }
        if (this.signature.getReturnType().getTypeKind().isStackElement()) {
            MappedType returnType = this.signature.getReturnType().getMappedType();
            VariableDeclarator declarator = new VariableDeclarator();
            declarator.setType(returnType.abstractType());
            declarator.setName("_retPar");
            declarator.setInitializer((Expression)new ObjectCreationExpr().setType(returnType.abstractType()));
            VariableDeclarationExpr varDecl = new VariableDeclarationExpr();
            varDecl.addVariable(declarator);
            arguments.add((Node)new ExpressionStmt((Expression)varDecl));
            Expression writeArgExpr = returnType.writeToBufferPtr((Expression)new NameExpr("bufPtr"), JavaUtils.getOffsetAsExpression(this.signature.getArguments().length, this::getParameterOffset), returnType.toC((Expression)new NameExpr("_retPar")));
            arguments.add((Node)new ExpressionStmt(writeArgExpr));
        }
        BlockStmt lambdaBody = (BlockStmt)new BlockStmt().addStatement((Statement)new ExpressionStmt((Expression)useEncoderDeclaration));
        for (Statement statement : arguments) {
            lambdaBody.addStatement(statement);
        }
        lambdaBody.addStatement((Expression)new MethodCallExpr((Expression)new NameExpr("encoder"), "invoke", NodeList.nodeList((Node[])new Expression[]{new NameExpr("bufPtr")})));
        if (this.signature.getReturnType().getTypeKind() != TypeKind.VOID) {
            MappedType retMappedType = this.signature.getReturnType().getMappedType();
            if (!this.signature.getReturnType().getTypeKind().isStackElement()) {
                Expression readRetExpr = retMappedType.fromC(retMappedType.readFromBufferPtr((Expression)new NameExpr("bufPtr"), JavaUtils.getOffsetAsExpression(this.signature.getArguments().length, this::getParameterOffset)));
                VariableDeclarator declarator = ((VariableDeclarator)((VariableDeclarator)new VariableDeclarator().setType(retMappedType.abstractType())).setName("_retPar")).setInitializer(readRetExpr);
                VariableDeclarationExpr varDecl = new VariableDeclarationExpr(declarator);
                lambdaBody.addStatement((Expression)varDecl);
            }
            lambdaBody.addStatement((Statement)new ExpressionStmt((Expression)new MethodCallExpr((Expression)new NameExpr("encoder"), "finish", NodeList.nodeList((Node[])new Expression[]{new NameExpr("bufPtr")}))));
            lambdaBody.addStatement((Statement)new ReturnStmt((Expression)new NameExpr("_retPar")));
        }
        LambdaExpr lambda = new LambdaExpr().setEnclosingParameters(true).setBody((Statement)lambdaBody);
        for (NamedType namedType : this.signature.getArguments()) {
            namedType.getDefinition().getMappedType().importType(cu);
            lambda.addAndGetParameter((Type)new UnknownType(), namedType.getName());
        }
        ObjectCreationExpr closureObjectCreationExpr = (ObjectCreationExpr)((ObjectCreationExpr)((ObjectCreationExpr)((ObjectCreationExpr)new ObjectCreationExpr().setType("CClosureObject<>")).addArgument((Expression)lambda)).addArgument("fnPtr")).addArgument("encoder");
        ReturnStmt returnStmt = new ReturnStmt((Expression)closureObjectCreationExpr);
        stmt.addStatement((Statement)new ExpressionStmt((Expression)encoderDeclaration));
        stmt.addStatement((Statement)returnStmt);
    }

    @Override
    public void write(CompilationUnit cuPublic, ClassOrInterfaceDeclaration toWriteToPublic, CompilationUnit cuPrivate, ClassOrInterfaceDeclaration toWriteToPrivate) {
        String name = this.signature.getName();
        TypeDefinition returnType = this.signature.getReturnType();
        NamedType[] arguments = this.signature.getArguments();
        if (!returnType.getMappedType().isLibFFIConvertible() || !Arrays.stream(arguments).map(namedType -> namedType.getDefinition().getMappedType()).allMatch(MappedType::isLibFFIConvertible)) {
            throw new IllegalArgumentException("Unions are not allowed to be passed via stack from/to a closure, failing closure: " + name);
        }
        this.importType(cuPublic);
        cuPublic.addImport("com.badlogic.gdx.jnigen.runtime.closure.Closure");
        cuPublic.addImport(this.internalClass());
        cuPrivate.addImport("com.badlogic.gdx.jnigen.runtime.c.CTypeInfo");
        cuPrivate.addImport("com.badlogic.gdx.jnigen.runtime.closure.Closure");
        cuPrivate.addImport("com.badlogic.gdx.jnigen.runtime.mem.BufferPtr");
        cuPrivate.addImport("com.badlogic.gdx.jnigen.runtime.closure.PointingPoolManager");
        NodeList arrayInitializerExpr = new NodeList();
        ArrayCreationExpr arrayCreationExpr = new ArrayCreationExpr();
        arrayCreationExpr.setElementType("CTypeInfo");
        arrayCreationExpr.setInitializer(new ArrayInitializerExpr(arrayInitializerExpr));
        toWriteToPrivate.addFieldWithInitializer("CTypeInfo[]", "__ffi_cache", (Expression)arrayCreationExpr, new Modifier.Keyword[0]);
        MethodDeclaration callMethod = toWriteToPublic.addMethod(name + "_call", new Modifier.Keyword[0]);
        if (this.comment != null) {
            callMethod.setJavadocComment(this.comment);
        }
        callMethod.setBody(null);
        for (NamedType namedType2 : arguments) {
            namedType2.getDefinition().getMappedType().importType(cuPublic);
            callMethod.addAndGetParameter(namedType2.getDefinition().getMappedType().abstractType(), namedType2.getName());
            MethodCallExpr getTypeID = new MethodCallExpr("getCTypeInfo", new Expression[0]);
            getTypeID.setScope((Expression)new NameExpr("FFITypes"));
            getTypeID.addArgument((Expression)new IntegerLiteralExpr(String.valueOf(namedType2.getDefinition().getMappedType().typeID())));
            arrayInitializerExpr.add((Node)getTypeID);
        }
        returnType.getMappedType().importType(cuPublic);
        callMethod.setType(returnType.getMappedType().abstractType());
        toWriteToPrivate.addMember((BodyDeclaration)new MethodDeclaration(callMethod.getModifiers(), callMethod.getNameAsString(), callMethod.getType(), callMethod.getParameters()).setBody(null));
        MethodCallExpr getTypeID = new MethodCallExpr("getCTypeInfo", new Expression[0]);
        getTypeID.setScope((Expression)new NameExpr("FFITypes"));
        getTypeID.addArgument((Expression)new IntegerLiteralExpr(String.valueOf(returnType.getMappedType().typeID())));
        arrayInitializerExpr.add(0, (Node)getTypeID);
        ((MethodDeclaration)toWriteToPrivate.addMethod("functionSignature", new Modifier.Keyword[]{Modifier.Keyword.DEFAULT}).setType("CTypeInfo[]")).createBody().addStatement("return __ffi_cache;");
        MethodDeclaration invokeMethod = toWriteToPrivate.addMethod("invoke", new Modifier.Keyword[]{Modifier.Keyword.DEFAULT});
        invokeMethod.addParameter("BufferPtr", "buf");
        BlockStmt invokeBody = new BlockStmt();
        MethodCallExpr callExpr = new MethodCallExpr(callMethod.getNameAsString(), new Expression[0]);
        for (int i = 0; i < arguments.length; ++i) {
            NamedType type = arguments[i];
            TypeDefinition definition = type.getDefinition();
            Expression fromBuf = definition.getMappedType().readFromBufferPtr((Expression)new NameExpr("buf"), JavaUtils.getOffsetAsExpression(i, this::getParameterOffset));
            callExpr.addArgument(definition.getMappedType().fromC(fromBuf));
        }
        if (returnType.getTypeKind() == TypeKind.VOID) {
            invokeBody.addStatement((Expression)callExpr);
        } else {
            Expression toBuf = returnType.getMappedType().writeToBufferPtr((Expression)new NameExpr("buf"), (Expression)new IntegerLiteralExpr("0"), returnType.getMappedType().toC((Expression)callExpr));
            invokeBody.addStatement(toBuf);
        }
        invokeMethod.setBody(invokeBody);
        MethodDeclaration invokePooledMethod = toWriteToPrivate.addMethod("invokePooled", new Modifier.Keyword[]{Modifier.Keyword.DEFAULT});
        invokePooledMethod.addParameter("BufferPtr", "buf");
        invokePooledMethod.addParameter("PointingPoolManager", "manager");
        BlockStmt invokePooledBody = new BlockStmt();
        MethodCallExpr pooledCallExpr = new MethodCallExpr(callMethod.getNameAsString(), new Expression[0]);
        for (int i = 0; i < arguments.length; ++i) {
            NamedType type = arguments[i];
            TypeDefinition definition = type.getDefinition();
            Expression fromBuf = definition.getMappedType().readFromBufferPtr((Expression)new NameExpr("buf"), JavaUtils.getOffsetAsExpression(i, this::getParameterOffset));
            pooledCallExpr.addArgument(definition.getMappedType().fromCPooled(fromBuf, (Expression)new NameExpr("manager")));
        }
        if (returnType.getTypeKind() == TypeKind.VOID) {
            invokePooledBody.addStatement((Expression)pooledCallExpr);
        } else {
            Expression toBuf = returnType.getMappedType().writeToBufferPtr((Expression)new NameExpr("buf"), (Expression)new IntegerLiteralExpr("0"), returnType.getMappedType().toC((Expression)pooledCallExpr));
            invokePooledBody.addStatement(toBuf);
        }
        invokePooledMethod.setBody(invokePooledBody);
        this.writeHelper(cuPrivate, toWriteToPrivate);
    }

    private int getParameterOffset(int index, PossibleTarget target) {
        if (index < 0 || index > this.signature.getArguments().length) {
            throw new IllegalArgumentException("Index out of bounds: " + index);
        }
        int offset = 0;
        for (int i = 0; i < index; ++i) {
            offset += this.signature.getArguments()[i].getDefinition().getMappedType().getSizeFromC(target);
        }
        return offset;
    }

    private static Expression getMethodCallExpr(Expression expression, TypeDefinition type) {
        String methodName = "asLong";
        if (type.getTypeKind() == TypeKind.FLOAT) {
            methodName = "asFloat";
        } else if (type.getTypeKind() == TypeKind.DOUBLE) {
            methodName = "asDouble";
        } else if (type.getTypeKind() == TypeKind.BOOLEAN) {
            methodName = "asBoolean";
        }
        MethodCallExpr methodCallExpr = new MethodCallExpr(methodName, new Expression[0]);
        methodCallExpr.setScope(expression);
        return type.getMappedType().fromC((Expression)methodCallExpr);
    }

    public String getName() {
        return this.signature.getName();
    }

    public FunctionSignature getSignature() {
        return this.signature;
    }

    @Override
    public String abstractType() {
        return "ClosureObject<" + this.signature.getName() + ">";
    }

    @Override
    public String primitiveType() {
        return Long.TYPE.getName();
    }

    @Override
    public void importType(CompilationUnit cu) {
        cu.addImport("com.badlogic.gdx.jnigen.runtime.closure.ClosureObject");
        cu.addImport("com.badlogic.gdx.jnigen.runtime.CHandler");
        if (cu.getClassByName(this.parent.abstractType()).isPresent()) {
            return;
        }
        cu.addImport(this.classFile() + "." + this.signature.getName());
        cu.addImport(this.internalClass());
    }

    @Override
    public String classFile() {
        return this.parent.classFile();
    }

    @Override
    public String packageName() {
        return this.parent.packageName();
    }

    @Override
    public Expression fromC(Expression cRetrieved) {
        MethodCallExpr methodCallExpr = new MethodCallExpr("getClosureObject", new Expression[0]);
        methodCallExpr.setScope((Expression)new NameExpr("CHandler"));
        methodCallExpr.addArgument(cRetrieved);
        methodCallExpr.addArgument(this.internalClassName() + "::" + this.getName() + "_downcall");
        return methodCallExpr;
    }

    @Override
    public Expression toC(Expression cSend) {
        MethodCallExpr methodCallExpr = new MethodCallExpr("getPointer", new Expression[0]);
        methodCallExpr.setScope(cSend);
        return methodCallExpr;
    }

    @Override
    public int typeID() {
        return -1;
    }

    @Override
    public String internalClassName() {
        return this.getName() + "_Internal";
    }

    @Override
    public String internalClass() {
        return this.parent.internalClass() + "." + this.internalClassName();
    }

    @Override
    public Expression writeToBufferPtr(Expression bufferPtr, Expression offset, Expression valueToWrite) {
        return new MethodCallExpr("setNativePointer", new Expression[]{offset, valueToWrite}).setScope(bufferPtr);
    }

    @Override
    public Expression readFromBufferPtr(Expression bufferPtr, Expression offset) {
        return new MethodCallExpr("getNativePointer", new Expression[]{offset}).setScope(bufferPtr);
    }

    @Override
    public int getSize(PossibleTarget target) {
        return target.is32Bit() ? 4 : 8;
    }
}

