/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.generator.types;

import com.badlogic.gdx.jnigen.generator.JavaUtils;
import com.badlogic.gdx.jnigen.generator.Manager;
import com.badlogic.gdx.jnigen.generator.PossibleTarget;
import com.badlogic.gdx.jnigen.generator.types.EnumConstant;
import com.badlogic.gdx.jnigen.generator.types.MappedType;
import com.badlogic.gdx.jnigen.generator.types.PrimitiveType;
import com.badlogic.gdx.jnigen.generator.types.TypeDefinition;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.SwitchEntry;
import com.github.javaparser.ast.stmt.SwitchStmt;
import java.util.Comparator;
import java.util.HashMap;

public class EnumType
implements MappedType {
    private final TypeDefinition definition;
    private final String javaName;
    private final HashMap<Integer, EnumConstant> constants = new HashMap();
    private int highestConstantID = Integer.MIN_VALUE;
    private int lowestConstantID = Integer.MAX_VALUE;
    private String comment;

    public EnumType(TypeDefinition definition, String javaName) {
        this.definition = definition;
        this.javaName = javaName;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void registerConstant(EnumConstant constant) {
        if (this.constants.values().stream().anyMatch(e -> e.getName().equals(constant.getName()))) {
            throw new IllegalArgumentException("Enum " + this.javaName + " already has constant with name: " + constant.getName());
        }
        if (this.constants.containsKey(constant.getId())) {
            this.constants.computeIfPresent(constant.getId(), (integer, old_const) -> new EnumConstant((int)integer, old_const.getName() + "_" + constant.getName(), constant.getComment()));
            return;
        }
        this.constants.put(constant.getId(), constant);
        if (constant.getId() > this.highestConstantID) {
            this.highestConstantID = constant.getId();
        }
        if (constant.getId() < this.lowestConstantID) {
            this.lowestConstantID = constant.getId();
        }
    }

    public void write(CompilationUnit cu) {
        cu.addImport("com.badlogic.gdx.jnigen.runtime.pointer.EnumPointer");
        cu.addImport("com.badlogic.gdx.jnigen.runtime.c.CEnum");
        cu.addImport("com.badlogic.gdx.jnigen.runtime.CHandler");
        cu.addImport("com.badlogic.gdx.jnigen.runtime.pointer.VoidPointer");
        EnumDeclaration declaration = cu.addEnum(this.javaName);
        declaration.addImplementedType("CEnum");
        if (this.comment != null) {
            declaration.setJavadocComment(this.comment);
        }
        declaration.addFieldWithInitializer("int", "__size", JavaUtils.getSizeAsExpression(this::getSize), new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.STATIC, Modifier.Keyword.FINAL});
        this.constants.values().stream().sorted(Comparator.comparingInt(EnumConstant::getId)).forEach(constant -> {
            EnumConstantDeclaration dec = (EnumConstantDeclaration)declaration.addEnumConstant(constant.getName()).addArgument((Expression)new IntegerLiteralExpr(String.valueOf(constant.getId())));
            if (constant.getComment() != null) {
                dec.setJavadocComment(constant.getComment());
            }
        });
        declaration.addField(Integer.TYPE, "index", new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.FINAL});
        ConstructorDeclaration constructor = (ConstructorDeclaration)declaration.addConstructor(new Modifier.Keyword[0]).addParameter(Integer.TYPE, "index");
        constructor.createBody().addStatement("this.index = index;");
        ((MethodDeclaration)declaration.addMethod("getIndex", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).setType(Integer.TYPE)).createBody().addStatement((Statement)new ReturnStmt("index"));
        ((MethodDeclaration)declaration.addMethod("getSize", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).setType(Integer.TYPE)).createBody().addStatement((Statement)new ReturnStmt("__size"));
        MethodDeclaration getByIndex = declaration.addMethod("getByIndex", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.STATIC});
        getByIndex.addParameter(Integer.TYPE, "index");
        getByIndex.setType(this.javaName);
        SwitchStmt switchStmt = new SwitchStmt();
        switchStmt.setSelector((Expression)new NameExpr("index"));
        this.constants.values().forEach(enumConstant -> {
            SwitchEntry switchEntry = new SwitchEntry();
            switchEntry.setLabels(NodeList.nodeList((Node[])new Expression[]{new IntegerLiteralExpr(String.valueOf(enumConstant.getId()))}));
            ReturnStmt returnStmt = new ReturnStmt();
            returnStmt.setExpression((Expression)new NameExpr(enumConstant.getName()));
            switchEntry.setStatements(NodeList.nodeList((Node[])new Statement[]{returnStmt}));
            switchStmt.getEntries().add((Node)switchEntry);
        });
        SwitchEntry defaultEntry = new SwitchEntry();
        defaultEntry.setDefault(true);
        Statement throwStatement = StaticJavaParser.parseStatement((String)"throw new IllegalArgumentException(\"Index \" + index + \" does not exist.\");");
        defaultEntry.setStatements(NodeList.nodeList((Node[])new Statement[]{throwStatement}));
        switchStmt.getEntries().add((Node)defaultEntry);
        getByIndex.createBody().addStatement((Statement)switchStmt);
        String pointerName = this.javaName + "Pointer";
        ClassOrInterfaceDeclaration pointerClass = new ClassOrInterfaceDeclaration(new NodeList((Node[])new Modifier[]{Modifier.publicModifier(), Modifier.staticModifier(), Modifier.finalModifier()}), false, pointerName);
        declaration.addMember((BodyDeclaration)pointerClass);
        pointerClass.addExtendedType("EnumPointer<" + this.javaName + ">");
        ((ConstructorDeclaration)pointerClass.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).addParameter("VoidPointer", "pointer")).getBody().addStatement("super(pointer);");
        ConstructorDeclaration pointerConstructor = pointerClass.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        pointerConstructor.addParameter(Long.TYPE, "pointer");
        pointerConstructor.addParameter(Boolean.TYPE, "freeOnGC");
        BlockStmt body = new BlockStmt();
        body.addStatement("super(pointer, freeOnGC);");
        pointerConstructor.setBody(body);
        ConstructorDeclaration pointerConstructorCapacity = pointerClass.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        pointerConstructorCapacity.addParameter(Long.TYPE, "pointer");
        pointerConstructorCapacity.addParameter(Boolean.TYPE, "freeOnGC");
        pointerConstructorCapacity.addParameter(Integer.TYPE, "capacity");
        BlockStmt bodyCapacity = new BlockStmt();
        bodyCapacity.addStatement("super(pointer, freeOnGC, capacity * __size);");
        pointerConstructorCapacity.setBody(bodyCapacity);
        pointerClass.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).getBody().addStatement("this(1, true);");
        ConstructorDeclaration defaultConstructorPointer = pointerClass.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        defaultConstructorPointer.addParameter(Integer.TYPE, "count");
        defaultConstructorPointer.addParameter(Boolean.TYPE, "freeOnGC");
        defaultConstructorPointer.createBody().addStatement("super(count * __size, freeOnGC);");
        Expression readExpr = this.getBackingPrimitiveType().readFromBufferPtr((Expression)new MethodCallExpr("getBufPtr", new Expression[0]), StaticJavaParser.parseExpression((String)"index * __size"));
        CastExpr castToInt = ((CastExpr)new CastExpr().setType(Integer.TYPE)).setExpression(readExpr);
        ((MethodDeclaration)((MethodDeclaration)pointerClass.addMethod("getEnumValue", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).setType(this.javaName)).addParameter(Integer.TYPE, "index")).createBody().addStatement((Statement)new ReturnStmt((Expression)new MethodCallExpr("getByIndex", new Expression[]{castToInt})));
        Expression writeExpr = this.getBackingPrimitiveType().writeToBufferPtr((Expression)new MethodCallExpr("getBufPtr", new Expression[0]), StaticJavaParser.parseExpression((String)"index * __size"), (Expression)new MethodCallExpr("getIndex", new Expression[0]).setScope((Expression)new NameExpr("value")));
        ((MethodDeclaration)((MethodDeclaration)((MethodDeclaration)pointerClass.addMethod("setEnumValue", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).setType(Void.TYPE)).addParameter(this.javaName, "value")).addParameter(Integer.TYPE, "index")).createBody().addStatement(writeExpr);
    }

    public PrimitiveType getBackingPrimitiveType() {
        return (PrimitiveType)this.definition.getNestedDefinition().getMappedType();
    }

    @Override
    public void importType(CompilationUnit cu) {
        cu.addImport(this.classFile());
    }

    @Override
    public String classFile() {
        return this.packageName() + "." + this.javaName;
    }

    @Override
    public String packageName() {
        return Manager.getInstance().getBasePackage() + ".enums";
    }

    @Override
    public String abstractType() {
        return this.javaName;
    }

    @Override
    public String primitiveType() {
        return Integer.TYPE.getName();
    }

    @Override
    public Expression fromC(Expression cRetrieved) {
        CastExpr intCast = new CastExpr();
        intCast.setType(Integer.TYPE);
        intCast.setExpression(cRetrieved);
        MethodCallExpr callByIndex = new MethodCallExpr("getByIndex", new Expression[]{intCast});
        callByIndex.setScope((Expression)new NameExpr(this.instantiationType()));
        return callByIndex;
    }

    @Override
    public Expression toC(Expression cSend) {
        MethodCallExpr methodCallExpr = new MethodCallExpr("getIndex", new Expression[0]);
        methodCallExpr.setScope(cSend);
        return methodCallExpr;
    }

    @Override
    public int typeID() {
        return this.definition.getNestedDefinition().getMappedType().typeID();
    }

    @Override
    public Expression writeToBufferPtr(Expression bufferPtr, Expression offset, Expression valueToWrite) {
        return this.getBackingPrimitiveType().writeToBufferPtr(bufferPtr, offset, valueToWrite);
    }

    @Override
    public Expression readFromBufferPtr(Expression bufferPtr, Expression offset) {
        return this.getBackingPrimitiveType().readFromBufferPtr(bufferPtr, offset);
    }

    @Override
    public int getSize(PossibleTarget target) {
        return this.definition.getNestedDefinition().getMappedType().getSize(target);
    }
}

