/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.generator.types;

import com.badlogic.gdx.jnigen.generator.types.FunctionSignature;
import com.badlogic.gdx.jnigen.generator.types.NamedType;
import com.badlogic.gdx.jnigen.generator.types.PointerType;
import com.badlogic.gdx.jnigen.generator.types.TypeDefinition;
import com.badlogic.gdx.jnigen.generator.types.TypeKind;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.util.HashMap;

public class FunctionType {
    private final FunctionSignature signature;
    private final String comment;

    public FunctionType(FunctionSignature signature, String comment) {
        this.signature = signature;
        this.comment = comment;
    }

    public FunctionSignature getSignature() {
        return this.signature;
    }

    public void write(CompilationUnit cu, ClassOrInterfaceDeclaration wrappingClass, HashMap<MethodDeclaration, String> patchNativeMethod) {
        String name = this.signature.getName();
        TypeDefinition returnType = this.signature.getReturnType();
        NamedType[] arguments = this.signature.getArguments();
        MethodDeclaration callMethodCreate = wrappingClass.addMethod(name, new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.STATIC});
        if (this.comment != null) {
            callMethodCreate.setJavadocComment(this.comment);
        }
        BlockStmt body = new BlockStmt();
        MethodDeclaration nativeMethod = ((MethodDeclaration)((MethodDeclaration)((MethodDeclaration)((MethodDeclaration)new MethodDeclaration().setName(name + "_internal")).setType(returnType.getMappedType().primitiveType())).setPublic(true)).setStatic(true)).setNative(true).setBody(null);
        callMethodCreate.setType(returnType.getMappedType().abstractType());
        returnType.getMappedType().importType(cu);
        nativeMethod.setType(returnType.getMappedType().primitiveType());
        MethodCallExpr callExprCreate = new MethodCallExpr(nativeMethod.getNameAsString(), new Expression[0]);
        StringBuilder nativeBody = new StringBuilder();
        nativeBody.append(name).append("(");
        for (NamedType namedType : arguments) {
            namedType.getDefinition().getMappedType().importType(cu);
            callMethodCreate.addParameter(namedType.getDefinition().getMappedType().abstractType(), namedType.getName());
            if (namedType.getDefinition().getTypeKind().isStackElement()) {
                nativeBody.append("*(").append(namedType.getDefinition().getTypeName()).append("*)").append(namedType.getName()).append(", ");
            } else {
                nativeBody.append("(").append(namedType.getDefinition().getTypeName()).append(")").append(namedType.getName()).append(", ");
            }
            nativeMethod.addParameter(namedType.getDefinition().getMappedType().primitiveType(), namedType.getName());
            callExprCreate.addArgument(namedType.getDefinition().getMappedType().toC((Expression)new NameExpr(namedType.getName())));
        }
        if (arguments.length != 0) {
            nativeBody.delete(nativeBody.length() - 2, nativeBody.length());
        }
        nativeBody.append(");");
        if (returnType.getTypeKind() != TypeKind.VOID) {
            if (returnType.getTypeKind().isPrimitive()) {
                nativeBody.insert(0, "return (j" + returnType.getMappedType().primitiveType() + ")");
                body.addStatement((Statement)new ReturnStmt((Expression)callExprCreate));
            } else {
                if (returnType.getTypeKind() == TypeKind.POINTER || returnType.getTypeKind().isStackElement()) {
                    MethodDeclaration callMethodParameter = callMethodCreate.clone();
                    callMethodParameter.addParameter(returnType.getMappedType().abstractType(), "_retPar");
                    callMethodParameter.setType(Void.TYPE);
                    if (returnType.getTypeKind().isStackElement()) {
                        MethodCallExpr callExprParameter = callExprCreate.clone();
                        callExprParameter.addArgument(returnType.getMappedType().toC((Expression)new NameExpr("_retPar")));
                        BlockStmt bodyParameter = body.clone();
                        bodyParameter.addStatement((Expression)callExprParameter);
                        callMethodParameter.setBody(bodyParameter);
                        callExprCreate.addArgument("0");
                        nativeMethod.addParameter(Long.TYPE, "_retPar");
                        nativeBody.insert(0, "*_ret = ");
                        nativeBody.insert(0, returnType.getTypeName() + "* _ret = (" + returnType.getTypeName() + "*) (_retPar == 0 ? malloc(sizeof(" + returnType.getTypeName() + ")) : (void*)_retPar);\n");
                        nativeBody.append("\nreturn (jlong)_ret;");
                    } else {
                        PointerType pointerType = (PointerType)returnType.getMappedType();
                        BlockStmt bodyPar = callMethodParameter.createBody();
                        bodyPar.addStatement((Expression)new MethodCallExpr((Expression)new NameExpr("_retPar"), "setPointer", new NodeList((Node[])new Expression[]{callExprCreate})));
                        if (pointerType.isPointerPointer()) {
                            bodyPar.addStatement((Expression)new MethodCallExpr((Expression)new NameExpr("_retPar"), "setPointerSupplier", new NodeList((Node[])new Expression[]{pointerType.getPointerPointerSupplier()})));
                        }
                    }
                    wrappingClass.addMember((BodyDeclaration)callMethodParameter);
                }
                if (!returnType.getTypeKind().isStackElement()) {
                    nativeBody.insert(0, "return (j" + returnType.getMappedType().primitiveType() + ")");
                }
                body.addStatement((Statement)new ReturnStmt(returnType.getMappedType().fromC((Expression)callExprCreate)));
            }
        } else {
            body.addStatement((Expression)callExprCreate);
        }
        callMethodCreate.setBody(body);
        for (int i = 0; i < arguments.length; ++i) {
            NamedType namedType = arguments[i];
            TypeKind typeKind = namedType.getDefinition().getTypeKind();
            if (!typeKind.isPrimitive() || typeKind == TypeKind.FLOAT || typeKind == TypeKind.DOUBLE) continue;
            String ret = returnType.getTypeKind() == TypeKind.VOID ? "return" : "return 0";
            nativeBody.insert(0, "CHECK_AND_THROW_C_TYPE(env, " + namedType.getDefinition().getTypeName() + ", " + namedType.getName() + ", " + i + ", " + ret + ");\n");
        }
        nativeBody.insert(0, "HANDLE_JAVA_EXCEPTION_START()\n");
        nativeBody.append("\nHANDLE_JAVA_EXCEPTION_END()");
        if (returnType.getTypeKind() != TypeKind.VOID) {
            nativeBody.append("\nreturn 0;");
        }
        wrappingClass.getMembers().add((Node)nativeMethod);
        patchNativeMethod.put(nativeMethod, nativeBody.toString());
    }
}

