/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.generator.types;

import com.badlogic.gdx.jnigen.generator.Manager;
import com.badlogic.gdx.jnigen.generator.PossibleTarget;
import com.badlogic.gdx.jnigen.generator.types.ClosureType;
import com.badlogic.gdx.jnigen.generator.types.FunctionType;
import com.badlogic.gdx.jnigen.generator.types.MappedType;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.comments.BlockComment;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GlobalType
implements MappedType {
    private final HashMap<String, ClosureType> closures = new HashMap();
    private final List<FunctionType> functions = new ArrayList<FunctionType>();
    private final String globalName;

    public GlobalType(String globalName) {
        this.globalName = globalName;
    }

    public GlobalType duplicate() {
        GlobalType clone = new GlobalType(this.globalName);
        clone.functions.addAll(this.functions);
        clone.closures.putAll(this.closures);
        return clone;
    }

    public void addClosure(ClosureType closureType) {
        if (this.closures.containsKey(closureType.getName())) {
            throw new IllegalArgumentException("Closure with name: " + closureType.getName() + " already exists.");
        }
        this.closures.put(closureType.getName(), closureType);
    }

    public void addFunction(FunctionType functionType) {
        this.functions.add(functionType);
    }

    public List<FunctionType> getFunctions() {
        return this.functions;
    }

    public void write(CompilationUnit cuPublic, ClassOrInterfaceDeclaration global, CompilationUnit cuInternal, ClassOrInterfaceDeclaration globalInternal, HashMap<MethodDeclaration, String> patchNativeMethods) {
        cuPublic.addImport("com.badlogic.gdx.jnigen.runtime.c.CXXException");
        cuPublic.addImport(IllegalArgumentException.class);
        ((BlockStmt)((BlockStmt)global.addStaticInitializer().addStatement("CHandler.init();")).addStatement("FFITypes.init();")).addStatement("init(IllegalArgumentException.class, CXXException.class);");
        global.addMethod("initialize", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.STATIC}).createBody();
        global.addOrphanComment((Comment)new BlockComment("JNI\n#include <jnigen.h>\n#include <" + Manager.getInstance().getParsedCHeader() + ">\n\nstatic jclass illegalArgumentExceptionClass = NULL;\nstatic jclass cxxExceptionClass = NULL;\n"));
        MethodDeclaration initMethod = global.addMethod("init", new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.STATIC, Modifier.Keyword.NATIVE});
        ((MethodDeclaration)((MethodDeclaration)((MethodDeclaration)initMethod.setType(Void.TYPE)).addParameter((Type)((ClassOrInterfaceType)new ClassOrInterfaceType().setName("Class")).setTypeArguments(new Type[]{new WildcardType()}), "illegalArgumentException")).addParameter((Type)((ClassOrInterfaceType)new ClassOrInterfaceType().setName("Class")).setTypeArguments(new Type[]{new WildcardType()}), "cxxException")).setBody(null);
        patchNativeMethods.put(initMethod, "illegalArgumentExceptionClass = (jclass)env->NewGlobalRef(illegalArgumentException);\ncxxExceptionClass = (jclass)env->NewGlobalRef(cxxException);");
        for (FunctionType functionType : this.functions) {
            functionType.write(cuPublic, global, patchNativeMethods);
        }
        for (ClosureType closureType : this.closures.values()) {
            ClassOrInterfaceDeclaration declaration = closureType.generateClass();
            ClassOrInterfaceDeclaration declarationInternal = closureType.generateClassInternal();
            closureType.write(cuPublic, declaration, cuInternal, declarationInternal);
            global.addMember((BodyDeclaration)declaration);
            globalInternal.addMember((BodyDeclaration)declarationInternal);
        }
    }

    @Override
    public void importType(CompilationUnit cu) {
        cu.addImport(this.classFile());
    }

    @Override
    public String instantiationType() {
        throw new IllegalArgumentException();
    }

    @Override
    public String abstractType() {
        return this.globalName;
    }

    @Override
    public String primitiveType() {
        throw new IllegalArgumentException();
    }

    @Override
    public String classFile() {
        return Manager.getInstance().getBasePackage() + "." + this.globalName;
    }

    @Override
    public String packageName() {
        return Manager.getInstance().getBasePackage();
    }

    @Override
    public Expression fromC(Expression cRetrieved) {
        throw new IllegalArgumentException("Should not reach");
    }

    @Override
    public Expression toC(Expression cSend) {
        throw new IllegalArgumentException("Should not reach");
    }

    @Override
    public int typeID() {
        throw new IllegalArgumentException("Should not reach");
    }

    @Override
    public Expression readFromBufferPtr(Expression bufferPtr, Expression offset) {
        throw new IllegalArgumentException("Should not reach");
    }

    @Override
    public Expression writeToBufferPtr(Expression bufferPtr, Expression offset, Expression valueToWrite) {
        throw new IllegalArgumentException("Should not reach");
    }

    @Override
    public int getSize(PossibleTarget target) {
        throw new IllegalArgumentException("Should not reach");
    }
}

