/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.generator.types;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import javax.lang.model.SourceVersion;

public class MacroType {
    private final String name;
    private final String value;
    private final String comment;

    public MacroType(String name, String value, String comment) {
        this.name = name;
        this.value = value;
        this.comment = comment;
    }

    public void write(CompilationUnit cu, ClassOrInterfaceDeclaration wrappingClass) {
        String processedValue = this.value;
        String processedName = this.name;
        if (processedValue.startsWith("(") && processedValue.endsWith(")")) {
            processedValue = processedValue.substring(1, processedValue.length() - 1);
        }
        for (int i = 0; i < 3; ++i) {
            if (processedValue.isEmpty()) {
                return;
            }
            char indexLowerCase = processedValue.toLowerCase().charAt(processedValue.length() - 1);
            if (indexLowerCase != 'l' && indexLowerCase != 'u') break;
            processedValue = processedValue.substring(0, processedValue.length() - 1);
        }
        if (SourceVersion.isKeyword(processedName)) {
            processedName = processedName + "_r";
        }
        FieldDeclaration declaration = null;
        try {
            Class<Comparable<Byte>> lowestBound;
            long l = Long.decode(processedValue);
            if (l <= 127L && l >= -128L) {
                lowestBound = Byte.TYPE;
            } else if (l <= 32767L && l >= -32768L) {
                lowestBound = Short.TYPE;
            } else if (l <= 65535L && l >= 0L) {
                lowestBound = Character.TYPE;
            } else if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                lowestBound = Integer.TYPE;
            } else {
                processedValue = processedValue + "L";
                lowestBound = Long.TYPE;
            }
            declaration = wrappingClass.addFieldWithInitializer(lowestBound, processedName, (Expression)new IntegerLiteralExpr(processedValue), new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.STATIC, Modifier.Keyword.FINAL});
        }
        catch (NumberFormatException ignored) {
            try {
                if (processedValue.endsWith("L") || processedValue.endsWith("l")) {
                    processedValue = processedValue.substring(0, processedValue.length() - 1);
                }
                Double.parseDouble(processedValue);
                boolean isFloat = processedValue.endsWith("f") || processedValue.endsWith("F");
                Class<Number> lowestBound = isFloat ? Float.TYPE : Double.TYPE;
                declaration = wrappingClass.addFieldWithInitializer(lowestBound, processedName, (Expression)new DoubleLiteralExpr(processedValue), new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.STATIC, Modifier.Keyword.FINAL});
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (declaration != null && this.comment != null) {
            declaration.setJavadocComment(this.comment);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getComment() {
        return this.comment;
    }
}

