/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.generator.types;

import com.badlogic.gdx.jnigen.generator.PossibleTarget;
import com.badlogic.gdx.jnigen.generator.types.MappedType;
import com.badlogic.gdx.jnigen.generator.types.TypeDefinition;
import com.badlogic.gdx.jnigen.generator.types.TypeKind;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;

public class PointerType
implements MappedType {
    private final TypeDefinition pointingTo;

    public PointerType(TypeDefinition pointingTo) {
        this.pointingTo = pointingTo;
    }

    public boolean isPointerPointer() {
        return this.pointingTo.getTypeKind() == TypeKind.POINTER;
    }

    public boolean isEnumPointer() {
        return this.pointingTo.getTypeKind() == TypeKind.ENUM;
    }

    public boolean isStackElementPointer() {
        return this.pointingTo.getTypeKind().isStackElement();
    }

    public boolean isDoublePointer() {
        return this.pointingTo.getTypeKind() == TypeKind.DOUBLE;
    }

    public boolean isFloatPointer() {
        return this.pointingTo.getTypeKind() == TypeKind.FLOAT;
    }

    public boolean isIntPointer() {
        return this.pointingTo.getTypeKind().isPrimitive() && !this.isFloatPointer() && !this.isDoublePointer();
    }

    public boolean isVoidPointer() {
        return this.pointingTo.getTypeKind() == TypeKind.VOID;
    }

    private String findJavaPointerForIntPointer() {
        if (!this.isIntPointer()) {
            throw new IllegalArgumentException("Trying to find int pointer for non-integer pointer type");
        }
        switch (this.pointingTo.getTypeKind()) {
            case NATIVE_BYTE: {
                return "BytePointer";
            }
            case SIGNED_BYTE: {
                return "SBytePointer";
            }
            case BOOLEAN: 
            case PROMOTED_BYTE: {
                return "UBytePointer";
            }
            case SHORT: {
                return "SShortPointer";
            }
            case CHAR: {
                return "UShortPointer";
            }
            case INT: {
                return "SIntPointer";
            }
            case PROMOTED_INT: {
                return "UIntPointer";
            }
            case LONG: {
                return "SLongPointer";
            }
            case PROMOTED_LONG: {
                return "ULongPointer";
            }
            case LONG_LONG: {
                return "SInt64Pointer";
            }
            case PROMOTED_LONG_LONG: {
                return "UInt64Pointer";
            }
        }
        throw new IllegalArgumentException("Type " + this + " is not a primitive type");
    }

    @Override
    public void importType(CompilationUnit cu) {
        if (this.isStackElementPointer()) {
            this.pointingTo.getMappedType().importType(cu);
        } else if (this.isFloatPointer()) {
            cu.addImport("com.badlogic.gdx.jnigen.runtime.pointer.FloatPointer");
        } else if (this.isDoublePointer()) {
            cu.addImport("com.badlogic.gdx.jnigen.runtime.pointer.DoublePointer");
        } else if (this.isIntPointer()) {
            cu.addImport("com.badlogic.gdx.jnigen.runtime.pointer.integer." + this.abstractType());
        } else if (this.isVoidPointer()) {
            cu.addImport("com.badlogic.gdx.jnigen.runtime.pointer.VoidPointer");
        } else if (this.isEnumPointer()) {
            this.pointingTo.getMappedType().importType(cu);
        } else if (this.isPointerPointer()) {
            cu.addImport("com.badlogic.gdx.jnigen.runtime.pointer.PointerPointer");
        } else {
            throw new IllegalArgumentException("Type " + (Object)((Object)this.pointingTo.getTypeKind()) + " can't be pointerized");
        }
        this.pointingTo.getMappedType().importType(cu);
    }

    @Override
    public String classFile() {
        throw new IllegalArgumentException();
    }

    @Override
    public String packageName() {
        throw new IllegalArgumentException();
    }

    @Override
    public String abstractType() {
        if (this.isIntPointer()) {
            return this.findJavaPointerForIntPointer();
        }
        if (this.isFloatPointer()) {
            return "FloatPointer";
        }
        if (this.isDoublePointer()) {
            return "DoublePointer";
        }
        if (this.isVoidPointer()) {
            return "VoidPointer";
        }
        if (this.isEnumPointer()) {
            return this.pointingTo.getMappedType().abstractType() + "." + this.pointingTo.getMappedType().abstractType() + "Pointer";
        }
        if (this.isStackElementPointer()) {
            return this.pointingTo.getMappedType().abstractType() + "." + this.pointingTo.getMappedType().abstractType() + "Pointer";
        }
        if (this.isPointerPointer()) {
            return "PointerPointer<" + this.pointingTo.getMappedType().abstractType() + ">";
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String instantiationType() {
        if (this.isPointerPointer()) {
            return "PointerPointer<>";
        }
        return MappedType.super.instantiationType();
    }

    @Override
    public String primitiveType() {
        return Long.TYPE.getName();
    }

    public Expression getPointerPointerSupplier() {
        if (!this.isPointerPointer()) {
            throw new IllegalArgumentException("Can't get supplier for non PointerPointer type");
        }
        PointerType childPointerType = (PointerType)this.pointingTo.getMappedType();
        if (childPointerType.isPointerPointer()) {
            LambdaExpr expr = new LambdaExpr();
            expr.setEnclosingParameters(true);
            Parameter peerPar = expr.addAndGetParameter(Long.TYPE, "peer" + this.pointingTo.getDepth());
            Parameter ownedPar = expr.addAndGetParameter(Boolean.TYPE, "owned" + this.pointingTo.getDepth());
            expr.setBody((Statement)new ExpressionStmt(this.pointingTo.getMappedType().fromC((Expression)peerPar.getNameAsExpression(), (Expression)ownedPar.getNameAsExpression())));
            return expr;
        }
        return new MethodReferenceExpr().setScope((Expression)new NameExpr(this.pointingTo.getMappedType().abstractType())).setIdentifier("new");
    }

    @Override
    public Expression fromC(Expression cRetrieved) {
        return this.fromC(cRetrieved, (Expression)new BooleanLiteralExpr(false));
    }

    @Override
    public Expression fromC(Expression cRetrieved, Expression owned) {
        ObjectCreationExpr createObject = new ObjectCreationExpr();
        createObject.setType(this.instantiationType());
        createObject.addArgument(cRetrieved);
        createObject.addArgument(String.valueOf(owned));
        if (this.isPointerPointer()) {
            createObject.addArgument(this.getPointerPointerSupplier());
        }
        return createObject;
    }

    @Override
    public Expression fromCPooled(Expression cRetrieved, Expression pool) {
        if (this.isPointerPointer()) {
            return (Expression)((MethodCallExpr)((MethodCallExpr)new MethodCallExpr("getPointerPointer", new Expression[0]).setScope(pool).addArgument((Expression)new ClassExpr().setType("PointerPointer"))).addArgument(cRetrieved)).addArgument(this.getPointerPointerSupplier());
        }
        return (Expression)((MethodCallExpr)new MethodCallExpr("getPointing", new Expression[0]).setScope(pool).addArgument((Expression)new ClassExpr().setType(this.abstractType()))).addArgument(cRetrieved);
    }

    @Override
    public Expression toC(Expression cSend) {
        MethodCallExpr methodCallExpr = new MethodCallExpr("getPointer", new Expression[0]);
        methodCallExpr.setScope(cSend);
        return methodCallExpr;
    }

    @Override
    public int typeID() {
        return -1;
    }

    @Override
    public Expression writeToBufferPtr(Expression bufferPtr, Expression offset, Expression valueToWrite) {
        return new MethodCallExpr("setNativePointer", new Expression[]{offset, valueToWrite}).setScope(bufferPtr);
    }

    @Override
    public Expression readFromBufferPtr(Expression bufferPtr, Expression offset) {
        return new MethodCallExpr("getNativePointer", new Expression[]{offset}).setScope(bufferPtr);
    }

    @Override
    public int getSize(PossibleTarget target) {
        return target.is32Bit() ? 4 : 8;
    }
}

