/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.generator.types;

import com.badlogic.gdx.jnigen.generator.Manager;
import com.badlogic.gdx.jnigen.generator.PossibleTarget;
import com.badlogic.gdx.jnigen.generator.types.MappedType;
import com.badlogic.gdx.jnigen.generator.types.TypeDefinition;
import com.badlogic.gdx.jnigen.generator.types.TypeKind;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;

public class PrimitiveType
implements MappedType {
    private final TypeDefinition definition;

    public PrimitiveType(TypeDefinition typeDefinition) {
        this.definition = typeDefinition;
    }

    public Class<?> getJavaRepresentation() {
        switch (this.definition.getTypeKind()) {
            case VOID: {
                return Void.TYPE;
            }
            case NATIVE_BYTE: 
            case SIGNED_BYTE: {
                return Byte.TYPE;
            }
            case PROMOTED_BYTE: 
            case CHAR: {
                return Character.TYPE;
            }
            case SHORT: {
                return Short.TYPE;
            }
            case INT: {
                return Integer.TYPE;
            }
            case PROMOTED_INT: 
            case PROMOTED_LONG: 
            case LONG_LONG: 
            case PROMOTED_LONG_LONG: 
            case LONG: {
                return Long.TYPE;
            }
            case FLOAT: {
                return Float.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
            case BOOLEAN: {
                return Boolean.TYPE;
            }
        }
        throw new IllegalArgumentException(this.definition.getTypeName() + " is not primitive.");
    }

    @Override
    public String abstractType() {
        return this.getJavaRepresentation().getName();
    }

    @Override
    public String primitiveType() {
        return this.getJavaRepresentation().getName();
    }

    @Override
    public void importType(CompilationUnit cu) {
    }

    @Override
    public String classFile() {
        throw new IllegalArgumentException();
    }

    @Override
    public String packageName() {
        throw new IllegalArgumentException();
    }

    @Override
    public Expression fromC(Expression cRetrieved) {
        return cRetrieved;
    }

    @Override
    public Expression toC(Expression cSend) {
        return cSend;
    }

    @Override
    public int typeID() {
        if (this.definition.getTypeKind() == TypeKind.VOID) {
            return -2;
        }
        return Manager.getInstance().getCTypeID(this.definition.getTypeName());
    }

    @Override
    public Expression writeToBufferPtr(Expression bufferPtr, Expression offset, Expression valueToWrite) {
        String methodName;
        switch (this.definition.getTypeKind()) {
            case BOOLEAN: {
                methodName = "setBoolean";
                break;
            }
            case NATIVE_BYTE: 
            case SIGNED_BYTE: {
                methodName = "setByte";
                break;
            }
            case PROMOTED_BYTE: {
                methodName = "setUByte";
                break;
            }
            case SHORT: {
                methodName = "setShort";
                break;
            }
            case CHAR: {
                methodName = "setChar";
                break;
            }
            case INT: {
                methodName = "setInt";
                break;
            }
            case PROMOTED_INT: {
                methodName = "setUInt";
                break;
            }
            case LONG: {
                methodName = "setNativeLong";
                break;
            }
            case PROMOTED_LONG: {
                methodName = "setNativeULong";
                break;
            }
            case LONG_LONG: 
            case PROMOTED_LONG_LONG: {
                methodName = "setLong";
                break;
            }
            case FLOAT: {
                methodName = "setFloat";
                break;
            }
            case DOUBLE: {
                methodName = "setDouble";
                break;
            }
            default: {
                throw new IllegalArgumentException(this.definition.getTypeName() + " is not primitive.");
            }
        }
        return new MethodCallExpr(methodName, new Expression[]{offset, valueToWrite}).setScope(bufferPtr);
    }

    @Override
    public Expression readFromBufferPtr(Expression bufferPtr, Expression offset) {
        String methodName;
        switch (this.definition.getTypeKind()) {
            case BOOLEAN: {
                methodName = "getBoolean";
                break;
            }
            case NATIVE_BYTE: 
            case SIGNED_BYTE: {
                methodName = "getByte";
                break;
            }
            case PROMOTED_BYTE: {
                methodName = "getUByte";
                break;
            }
            case SHORT: {
                methodName = "getShort";
                break;
            }
            case CHAR: {
                methodName = "getChar";
                break;
            }
            case INT: {
                methodName = "getInt";
                break;
            }
            case PROMOTED_INT: {
                methodName = "getUInt";
                break;
            }
            case LONG: {
                methodName = "getNativeLong";
                break;
            }
            case PROMOTED_LONG: {
                methodName = "getNativeULong";
                break;
            }
            case LONG_LONG: 
            case PROMOTED_LONG_LONG: {
                methodName = "getLong";
                break;
            }
            case FLOAT: {
                methodName = "getFloat";
                break;
            }
            case DOUBLE: {
                methodName = "getDouble";
                break;
            }
            default: {
                throw new IllegalArgumentException(this.definition.getTypeName() + " is not primitive.");
            }
        }
        return new MethodCallExpr(methodName, new Expression[]{offset}).setScope(bufferPtr);
    }

    @Override
    public int getSize(PossibleTarget target) {
        return this.definition.getTypeKind().getSize(target);
    }

    @Override
    public int getAlignment(PossibleTarget target) {
        return this.definition.getTypeKind().getAlignment(target);
    }
}

