/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.generator.types;

import com.badlogic.gdx.jnigen.generator.JavaUtils;
import com.badlogic.gdx.jnigen.generator.Manager;
import com.badlogic.gdx.jnigen.generator.PossibleTarget;
import com.badlogic.gdx.jnigen.generator.types.MappedType;
import com.badlogic.gdx.jnigen.generator.types.NamedType;
import com.badlogic.gdx.jnigen.generator.types.StackElementField;
import com.badlogic.gdx.jnigen.generator.types.TypeDefinition;
import com.badlogic.gdx.jnigen.generator.types.TypeKind;
import com.badlogic.gdx.jnigen.generator.types.WritableClass;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class StackElementType
implements MappedType,
WritableClass {
    private final TypeDefinition definition;
    private final MappedType parent;
    private final List<TypeDefinition> children = new ArrayList<TypeDefinition>();
    private final List<StackElementField> fields = new ArrayList<StackElementField>();
    private final String pointerName;
    private final String javaTypeName;
    private String comment;

    public StackElementType(TypeDefinition definition, String javaTypeName, MappedType parent) {
        this.definition = definition;
        this.javaTypeName = javaTypeName;
        this.parent = parent;
        this.pointerName = javaTypeName + "Pointer";
    }

    public void addField(StackElementField type) {
        this.fields.add(type);
    }

    public void addChild(TypeDefinition child) {
        this.children.add(child);
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public ClassOrInterfaceDeclaration generateClass() {
        NodeList modifiers = new NodeList((Node[])new Modifier[]{Modifier.publicModifier(), Modifier.finalModifier()});
        if (this.parent != null) {
            modifiers.add((Node)Modifier.staticModifier());
        }
        return new ClassOrInterfaceDeclaration(modifiers, false, this.javaTypeName);
    }

    @Override
    public ClassOrInterfaceDeclaration generateClassInternal() {
        NodeList modifiers = new NodeList((Node[])new Modifier[]{Modifier.publicModifier(), Modifier.finalModifier(), Modifier.staticModifier()});
        return new ClassOrInterfaceDeclaration(modifiers, false, this.internalClassName());
    }

    private void writeStackFields(StackElementField field, ClassOrInterfaceDeclaration toWriteToPublic) {
        NamedType fieldType = field.getType();
        MethodDeclaration reinterpretMethod = toWriteToPublic.addMethod(fieldType.getName(), new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        if (field.getComment() != null) {
            reinterpretMethod.setJavadocComment(field.getComment());
        }
        reinterpretMethod.setType(fieldType.getDefinition().getMappedType().abstractType());
        MethodCallExpr pointer = new MethodCallExpr("getPointer", new Expression[0]);
        Expression fieldOffset = this.getFieldOffsetAsExpression(this.fields.indexOf(field));
        if (this.isStruct() && !fieldOffset.toString().equals("0")) {
            pointer = new BinaryExpr((Expression)pointer, (Expression)new EnclosedExpr(fieldOffset), BinaryExpr.Operator.PLUS);
        }
        Expression fromCExpression = fieldType.getDefinition().getMappedType().fromC((Expression)pointer, (Expression)new BooleanLiteralExpr(false));
        if (fieldType.getDefinition().getTypeKind() == TypeKind.FIXED_SIZE_ARRAY) {
            fromCExpression.asObjectCreationExpr().addArgument(fieldType.getDefinition().getCount() + "");
        }
        reinterpretMethod.createBody().addStatement((Statement)new ReturnStmt(fromCExpression));
        MethodDeclaration reinterpretSetMethod = (MethodDeclaration)toWriteToPublic.addMethod(fieldType.getName(), new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).addParameter(fieldType.getDefinition().getMappedType().abstractType(), "toSetPtr");
        if (field.getComment() != null) {
            reinterpretSetMethod.setJavadocComment(field.getComment());
        }
        MethodCallExpr setPtr = (MethodCallExpr)((MethodCallExpr)((MethodCallExpr)new MethodCallExpr("setPointer", new Expression[0]).setScope((Expression)new NameExpr("toSetPtr")).addArgument((Expression)pointer)).addArgument(this.getFieldSizeAsExpression(this.fields.indexOf(field)))).addArgument((Expression)new ThisExpr());
        reinterpretSetMethod.createBody().addStatement((Expression)setPtr);
        MethodDeclaration cloneMethod = toWriteToPublic.addMethod(JavaUtils.getGetter(fieldType.getName()), new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        if (field.getComment() != null) {
            cloneMethod.setJavadocComment(field.getComment());
        }
        cloneMethod.setType(fieldType.getDefinition().getMappedType().abstractType());
        MethodCallExpr cloneExpr = (MethodCallExpr)((MethodCallExpr)new MethodCallExpr("duplicate", new Expression[0]).setScope((Expression)new MethodCallExpr("getBufPtr", new Expression[0])).addArgument(fieldOffset)).addArgument(this.getFieldSizeAsExpression(this.fields.indexOf(field)));
        Expression fromCClonesExpression = fieldType.getDefinition().getMappedType().fromC((Expression)cloneExpr);
        if (fieldType.getDefinition().getTypeKind() == TypeKind.FIXED_SIZE_ARRAY) {
            fromCClonesExpression.asObjectCreationExpr().addArgument(fieldType.getDefinition().getCount() + "");
        }
        cloneMethod.createBody().addStatement((Statement)new ReturnStmt(fromCClonesExpression));
        MethodDeclaration copyMethod = (MethodDeclaration)toWriteToPublic.addMethod(JavaUtils.getGetter(fieldType.getName()), new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).addParameter(fieldType.getDefinition().getMappedType().abstractType(), "toCopyTo");
        if (field.getComment() != null) {
            copyMethod.setJavadocComment(field.getComment());
        }
        MethodCallExpr copyExpr = (MethodCallExpr)((MethodCallExpr)((MethodCallExpr)((MethodCallExpr)new MethodCallExpr("copyFrom", new Expression[0]).setScope((Expression)new MethodCallExpr("getBufPtr", new Expression[0]).setScope((Expression)new NameExpr("toCopyTo"))).addArgument("0")).addArgument((Expression)new MethodCallExpr("getBufPtr", new Expression[0]))).addArgument(this.getFieldOffsetAsExpression(this.fields.indexOf(field)))).addArgument(this.getFieldSizeAsExpression(this.fields.indexOf(field)));
        copyMethod.createBody().addStatement((Expression)copyExpr);
        MethodDeclaration setMethod = (MethodDeclaration)toWriteToPublic.addMethod(JavaUtils.getSetter(fieldType.getName()), new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).addParameter(fieldType.getDefinition().getMappedType().abstractType(), "toCopyFrom");
        if (field.getComment() != null) {
            setMethod.setJavadocComment(field.getComment());
        }
        MethodCallExpr setExpr = (MethodCallExpr)((MethodCallExpr)((MethodCallExpr)((MethodCallExpr)new MethodCallExpr("copyFrom", new Expression[0]).setScope((Expression)new MethodCallExpr("getBufPtr", new Expression[0])).addArgument(this.getFieldOffsetAsExpression(this.fields.indexOf(field)))).addArgument((Expression)new MethodCallExpr("getBufPtr", new Expression[0]).setScope((Expression)new NameExpr("toCopyFrom")))).addArgument("0")).addArgument(this.getFieldSizeAsExpression(this.fields.indexOf(field)));
        setMethod.createBody().addStatement((Expression)setExpr);
    }

    @Override
    public void write(CompilationUnit cuPublic, ClassOrInterfaceDeclaration toWriteToPublic, CompilationUnit cuPrivate, ClassOrInterfaceDeclaration toWriteToPrivate) {
        String structPointerRef = this.javaTypeName + "." + this.pointerName;
        cuPublic.addImport("com.badlogic.gdx.jnigen.runtime.CHandler");
        cuPublic.addImport(this.isStruct() ? "com.badlogic.gdx.jnigen.runtime.pointer.Struct" : "com.badlogic.gdx.jnigen.runtime.pointer.Union");
        cuPublic.addImport("com.badlogic.gdx.jnigen.runtime.pointer.StackElementPointer");
        cuPublic.addImport("com.badlogic.gdx.jnigen.runtime.pointer.Pointing");
        cuPublic.addImport("com.badlogic.gdx.jnigen.runtime.pointer.VoidPointer");
        if (this.comment != null) {
            toWriteToPublic.setJavadocComment(this.comment);
        }
        toWriteToPublic.addExtendedType(this.isStruct() ? "Struct" : "Union");
        toWriteToPublic.addField(Integer.TYPE, "__size", new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.FINAL, Modifier.Keyword.STATIC});
        toWriteToPublic.addField(Long.TYPE, "__ffi_type", new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.FINAL, Modifier.Keyword.STATIC});
        BlockStmt staticInit = toWriteToPublic.addStaticInitializer();
        staticInit.addStatement("__ffi_type = FFITypes.getCTypeInfo(" + this.typeID() + ").getFfiType();");
        staticInit.addStatement("__size = CHandler.getSizeFromFFIType(__ffi_type);");
        cuPublic.addImport(Manager.getInstance().getBasePackage() + ".FFITypes");
        ConstructorDeclaration pointerTakingConstructor = toWriteToPublic.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        pointerTakingConstructor.addParameter(Long.TYPE, "pointer");
        pointerTakingConstructor.addParameter(Boolean.TYPE, "freeOnGC");
        pointerTakingConstructor.getBody().addStatement("super(pointer, freeOnGC);");
        ConstructorDeclaration pointerParentTakingConstructor = toWriteToPublic.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        pointerParentTakingConstructor.addParameter(Long.TYPE, "pointer");
        pointerParentTakingConstructor.addParameter(Boolean.TYPE, "freeOnGC");
        pointerParentTakingConstructor.addParameter("Pointing", "parent");
        ((BlockStmt)pointerParentTakingConstructor.getBody().addStatement("super(pointer, freeOnGC);")).addStatement("setParent(parent);");
        ConstructorDeclaration defaultConstructor = toWriteToPublic.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        defaultConstructor.getBody().addStatement("super(__size);");
        ((MethodDeclaration)toWriteToPublic.addMethod("getSize", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).setType(Long.TYPE)).createBody().addStatement("return __size;");
        ((MethodDeclaration)toWriteToPublic.addMethod("getFFIType", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).setType(Long.TYPE)).createBody().addStatement("return __ffi_type;");
        ((MethodDeclaration)toWriteToPublic.addMethod("asPointer", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).setType(structPointerRef)).createBody().addStatement("return new " + structPointerRef + "(getPointer(), false, 1, this);");
        ((MethodDeclaration)toWriteToPublic.addMethod("asPointer", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).addParameter(structPointerRef, "ptr")).createBody().addStatement((Expression)new MethodCallExpr((Expression)new NameExpr("ptr"), "setPointer").addArgument("this"));
        for (int i = 0; i < this.fields.size(); ++i) {
            StackElementField field = this.fields.get(i);
            NamedType fieldType = field.getType();
            fieldType.getDefinition().getMappedType().importType(cuPublic);
            if (fieldType.getDefinition().getTypeKind() == TypeKind.FIXED_SIZE_ARRAY || fieldType.getDefinition().getTypeKind().isStackElement()) {
                this.writeStackFields(field, toWriteToPublic);
                continue;
            }
            MethodDeclaration getMethod = toWriteToPublic.addMethod(fieldType.getName(), new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
            if (field.getComment() != null) {
                getMethod.setJavadocComment(field.getComment());
            }
            getMethod.setType(fieldType.getDefinition().getMappedType().abstractType());
            BlockStmt getBody = new BlockStmt();
            getBody.addStatement((Statement)new ReturnStmt(fieldType.getDefinition().getMappedType().fromC(fieldType.getDefinition().getMappedType().readFromBufferPtr((Expression)new MethodCallExpr("getBufPtr", new Expression[0]), this.getFieldOffsetAsExpression(i)))));
            getMethod.setBody(getBody);
            MethodDeclaration setMethod = toWriteToPublic.addMethod(fieldType.getName(), new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
            setMethod.addParameter(fieldType.getDefinition().getMappedType().abstractType(), fieldType.getName());
            if (field.getComment() != null) {
                setMethod.setJavadocComment(field.getComment());
            }
            BlockStmt setBody = new BlockStmt();
            setBody.addStatement(fieldType.getDefinition().getMappedType().writeToBufferPtr((Expression)new MethodCallExpr("getBufPtr", new Expression[0]), this.getFieldOffsetAsExpression(i), fieldType.getDefinition().getMappedType().toC((Expression)new NameExpr(fieldType.getName()))));
            setMethod.setBody(setBody);
        }
        ClassOrInterfaceDeclaration pointerClass = new ClassOrInterfaceDeclaration(new NodeList((Node[])new Modifier[]{Modifier.publicModifier(), Modifier.staticModifier(), Modifier.finalModifier()}), false, this.pointerName);
        toWriteToPublic.addMember((BodyDeclaration)pointerClass);
        pointerClass.addExtendedType("StackElementPointer<" + this.javaTypeName + ">");
        ((ConstructorDeclaration)pointerClass.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).addParameter("VoidPointer", "pointer")).getBody().addStatement("super(pointer);");
        ConstructorDeclaration pointerConstructor = pointerClass.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        pointerConstructor.addParameter(new Parameter((Type)PrimitiveType.longType(), "pointer"));
        pointerConstructor.addParameter(new Parameter((Type)PrimitiveType.booleanType(), "freeOnGC"));
        BlockStmt body = new BlockStmt();
        body.addStatement("super(pointer, freeOnGC);");
        pointerConstructor.setBody(body);
        ConstructorDeclaration pointerConstructorCapacity = pointerClass.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        pointerConstructorCapacity.addParameter(new Parameter((Type)PrimitiveType.longType(), "pointer"));
        pointerConstructorCapacity.addParameter(new Parameter((Type)PrimitiveType.booleanType(), "freeOnGC"));
        pointerConstructorCapacity.addParameter(new Parameter((Type)PrimitiveType.intType(), "capacity"));
        BlockStmt bodyCapacity = new BlockStmt();
        bodyCapacity.addStatement("super(pointer, freeOnGC, capacity * __size);");
        pointerConstructorCapacity.setBody(bodyCapacity);
        ConstructorDeclaration pointerAndParentTakingConstructor = pointerClass.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        pointerAndParentTakingConstructor.addParameter(Long.TYPE, "pointer");
        pointerAndParentTakingConstructor.addParameter(Boolean.TYPE, "freeOnGC");
        pointerAndParentTakingConstructor.addParameter("Pointing", "parent");
        ((BlockStmt)pointerAndParentTakingConstructor.getBody().addStatement("super(pointer, freeOnGC);")).addStatement("setParent(parent);");
        ConstructorDeclaration pointerAndParentAndCapacityTakingConstructor = pointerClass.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        pointerAndParentAndCapacityTakingConstructor.addParameter(Long.TYPE, "pointer");
        pointerAndParentAndCapacityTakingConstructor.addParameter(Boolean.TYPE, "freeOnGC");
        pointerAndParentAndCapacityTakingConstructor.addParameter(Integer.TYPE, "capacity");
        pointerAndParentAndCapacityTakingConstructor.addParameter("Pointing", "parent");
        ((BlockStmt)pointerAndParentAndCapacityTakingConstructor.getBody().addStatement("super(pointer, freeOnGC, capacity * __size);")).addStatement("setParent(parent);");
        pointerClass.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).getBody().addStatement("this(1, true);");
        ConstructorDeclaration defaultConstructorPointer = pointerClass.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        defaultConstructorPointer.addParameter(Integer.TYPE, "count");
        defaultConstructorPointer.addParameter(Boolean.TYPE, "freeOnGC");
        defaultConstructorPointer.createBody().addStatement("super(__size, count, freeOnGC);");
        ((MethodDeclaration)pointerClass.addMethod("getSize", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).setType(Integer.TYPE)).createBody().addStatement("return __size;");
        ((MethodDeclaration)((MethodDeclaration)((MethodDeclaration)pointerClass.addMethod("createStackElement", new Modifier.Keyword[]{Modifier.Keyword.PROTECTED}).setType(this.javaTypeName)).addParameter(Long.TYPE, "ptr")).addParameter(Boolean.TYPE, "freeOnGC")).createBody().addStatement("return new " + this.javaTypeName + "(ptr, freeOnGC);");
        this.children.forEach(child -> {
            WritableClass childStackElement = (WritableClass)((Object)child.getMappedType());
            ClassOrInterfaceDeclaration declaration = childStackElement.generateClass();
            ClassOrInterfaceDeclaration internalDeclaration = childStackElement.generateClassInternal();
            childStackElement.write(cuPublic, declaration, cuPrivate, internalDeclaration);
            toWriteToPublic.addMember((BodyDeclaration)declaration);
            toWriteToPrivate.addMember((BodyDeclaration)internalDeclaration);
        });
    }

    private ArrayList<NamedType> getUnwrappedFields() {
        ArrayList<NamedType> unwrappedFields = new ArrayList<NamedType>();
        for (StackElementField field : this.fields) {
            NamedType fieldType = field.getType();
            if (fieldType.getDefinition().getTypeKind() == TypeKind.FIXED_SIZE_ARRAY) {
                for (int i = 0; i < fieldType.getDefinition().getCount(); ++i) {
                    unwrappedFields.add(new NamedType(fieldType.getDefinition().getNestedDefinition(), fieldType.getName() + "_" + i));
                }
                continue;
            }
            unwrappedFields.add(fieldType);
        }
        return unwrappedFields;
    }

    public List<NamedType> getFields() {
        return this.fields.stream().map(StackElementField::getType).collect(Collectors.toList());
    }

    public String getFFITypeBody(String ffiResolveFunctionName) {
        ArrayList<NamedType> unwrappedFields = this.getUnwrappedFields();
        StringBuilder generateFFIMethodBody = new StringBuilder();
        if (this.isStruct()) {
            generateFFIMethodBody.append("\t\tnativeType->type = STRUCT_TYPE;\n");
        } else {
            generateFFIMethodBody.append("\t\tnativeType->type = UNION_TYPE;\n");
        }
        generateFFIMethodBody.append("\t\tnativeType->field_count = ").append(unwrappedFields.size()).append(";\n");
        generateFFIMethodBody.append("\t\tnativeType->fields = (native_type**)malloc(sizeof(native_type*) * ").append(unwrappedFields.size()).append(");\n");
        for (int i = 0; i < unwrappedFields.size(); ++i) {
            NamedType field = unwrappedFields.get(i);
            int fieldStructID = field.getDefinition().getMappedType().typeID();
            generateFFIMethodBody.append("\t\tnativeType->fields[").append(i).append("] = ").append(ffiResolveFunctionName).append("(").append(fieldStructID).append(");\n");
        }
        generateFFIMethodBody.append("\t\treturn nativeType;\n");
        return generateFFIMethodBody.toString();
    }

    public int getUnwrappedIndex(int index) {
        int unwrappedStartIndex = 0;
        for (int i = 0; i < index; ++i) {
            StackElementField field = this.fields.get(i);
            NamedType fieldType = field.getType();
            unwrappedStartIndex += fieldType.getDefinition().getCount();
        }
        return unwrappedStartIndex;
    }

    public int getFieldOffset(int index, PossibleTarget target) {
        if (!this.isStruct()) {
            return 0;
        }
        ArrayList<NamedType> unwrappedFields = this.getUnwrappedFields();
        if (index < 0 || index >= this.getFields().size()) {
            throw new IndexOutOfBoundsException("Field index " + index + " is out of bounds for struct with " + this.getFields().size() + " fields");
        }
        int unwrappedStartIndex = this.getUnwrappedIndex(index);
        int offset = 0;
        for (int i = 0; i <= unwrappedStartIndex; ++i) {
            NamedType fieldType = unwrappedFields.get(i);
            int fieldAlignment = fieldType.getDefinition().getMappedType().getAlignment(target);
            if (offset % fieldAlignment != 0) {
                offset += fieldAlignment - offset % fieldAlignment;
            }
            if (i == unwrappedStartIndex) continue;
            int fieldSize = fieldType.getDefinition().getMappedType().getSize(target);
            offset += fieldSize;
        }
        return offset;
    }

    public int getFieldSize(int index, PossibleTarget target) {
        StackElementField field = this.fields.get(index);
        NamedType fieldType = field.getType();
        int baseSize = fieldType.getDefinition().getMappedType().getSize(target);
        if (fieldType.getDefinition().getTypeKind() == TypeKind.FIXED_SIZE_ARRAY) {
            baseSize = fieldType.getDefinition().getNestedDefinition().getMappedType().getSize(target);
        }
        return baseSize * fieldType.getDefinition().getCount();
    }

    public Expression getFieldSizeAsExpression(int index) {
        return JavaUtils.getSizeAsExpression(target -> this.getFieldSize(index, target));
    }

    public Expression getFieldOffsetAsExpression(int index) {
        return JavaUtils.getOffsetAsExpression(index, this::getFieldOffset);
    }

    public boolean isStruct() {
        return this.definition.getTypeKind() == TypeKind.STRUCT;
    }

    @Override
    public String abstractType() {
        return this.javaTypeName;
    }

    @Override
    public String primitiveType() {
        return Long.TYPE.getName();
    }

    @Override
    public void importType(CompilationUnit cu) {
        cu.addImport(this.classFile());
    }

    @Override
    public String classFile() {
        if (this.parent != null) {
            return this.parent.classFile() + "." + this.javaTypeName;
        }
        return this.packageName() + "." + this.javaTypeName;
    }

    @Override
    public String packageName() {
        return Manager.getInstance().getBasePackage() + ".structs";
    }

    @Override
    public Expression fromC(Expression cRetrieved) {
        return this.fromC(cRetrieved, (Expression)new BooleanLiteralExpr(true));
    }

    @Override
    public Expression fromC(Expression cRetrieved, Expression owned) {
        ObjectCreationExpr createObject = new ObjectCreationExpr();
        createObject.setType(this.instantiationType());
        createObject.addArgument(cRetrieved);
        createObject.addArgument(String.valueOf(owned));
        return createObject;
    }

    @Override
    public Expression fromCPooled(Expression cRetrieved, Expression pool) {
        return (Expression)((MethodCallExpr)new MethodCallExpr("getPointing", new Expression[0]).setScope(pool).addArgument((Expression)new ClassExpr().setType(this.abstractType()))).addArgument(cRetrieved);
    }

    @Override
    public Expression toC(Expression cSend) {
        MethodCallExpr methodCallExpr = new MethodCallExpr("getPointer", new Expression[0]);
        methodCallExpr.setScope(cSend);
        return methodCallExpr;
    }

    @Override
    public int typeID() {
        return Manager.getInstance().getStackElementID(this);
    }

    @Override
    public boolean isLibFFIConvertible() {
        return this.isStruct();
    }

    @Override
    public String internalClass() {
        if (this.parent != null) {
            return this.parent.internalClass() + "." + this.internalClassName();
        }
        return Manager.getInstance().getGlobalType().internalClass() + "." + this.internalClassName();
    }

    @Override
    public Expression writeToBufferPtr(Expression bufferPtr, Expression offset, Expression valueToWrite) {
        return new MethodCallExpr("setNativePointer", new Expression[]{offset, valueToWrite}).setScope(bufferPtr);
    }

    @Override
    public Expression readFromBufferPtr(Expression bufferPtr, Expression offset) {
        return new MethodCallExpr("getNativePointer", new Expression[]{offset}).setScope(bufferPtr);
    }

    @Override
    public int getSize(PossibleTarget target) {
        int structSize = 0;
        int structAlignment = this.getAlignment(target);
        if (!this.isStruct()) {
            int maxSize = 0;
            for (NamedType fieldType : this.getUnwrappedFields()) {
                int fieldSize = fieldType.getDefinition().getMappedType().getSize(target);
                if (fieldSize <= maxSize) continue;
                maxSize = fieldSize;
            }
            return maxSize;
        }
        for (NamedType fieldType : this.getUnwrappedFields()) {
            int fieldAlignment = fieldType.getDefinition().getMappedType().getAlignment(target);
            int fieldSize = fieldType.getDefinition().getMappedType().getSize(target);
            if (structSize % fieldAlignment != 0) {
                structSize += fieldAlignment - structSize % fieldAlignment;
            }
            structSize += fieldSize;
        }
        if (structAlignment != 0 && structSize % structAlignment != 0) {
            structSize += structAlignment - structSize % structAlignment;
        }
        return structSize;
    }

    @Override
    public int getAlignment(PossibleTarget target) {
        int maxAlignment = 1;
        for (NamedType fieldType : this.getUnwrappedFields()) {
            int fieldAlignment = fieldType.getDefinition().getMappedType().getAlignment(target);
            if (fieldAlignment <= maxAlignment) continue;
            maxAlignment = fieldAlignment;
        }
        return maxAlignment;
    }

    @Override
    public int getSizeFromC(PossibleTarget target) {
        return target.is32Bit() ? 4 : 8;
    }
}

