/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.generator.types;

import com.badlogic.gdx.jnigen.generator.PossibleTarget;
import org.bytedeco.llvm.clang.CXCursor;
import org.bytedeco.llvm.clang.CXType;
import org.bytedeco.llvm.global.clang;

public enum TypeKind {
    VOID(2),
    BOOLEAN(3),
    NATIVE_BYTE(new int[0]),
    SIGNED_BYTE(13, 14),
    PROMOTED_BYTE(5, 4),
    SHORT(16),
    CHAR(8),
    INT(17),
    PROMOTED_INT(9),
    LONG(18),
    PROMOTED_LONG(10),
    LONG_LONG(19),
    PROMOTED_LONG_LONG(11),
    FLOAT(21),
    DOUBLE(22, 23),
    POINTER(101, 114),
    STRUCT(new int[0]),
    UNION(new int[0]),
    CLOSURE(111, 110),
    ENUM(106),
    FIXED_SIZE_ARRAY(112);

    private final int[] kinds;
    private static final TypeKind[] CACHE;

    private TypeKind(int ... kinds) {
        this.kinds = kinds;
    }

    public static TypeKind getTypeKind(CXType type) {
        CXType canonicalType = clang.clang_getCanonicalType((CXType)type);
        int kind = canonicalType.kind();
        if (kind == 105) {
            CXCursor cursor = clang.clang_getTypeDeclaration((CXType)type);
            return cursor.kind() == 2 ? STRUCT : UNION;
        }
        for (TypeKind typeKind : CACHE) {
            for (int k : typeKind.getKinds()) {
                if (k != kind) continue;
                return typeKind;
            }
        }
        throw new IllegalArgumentException("Could not find Kind for " + kind + " for type " + clang.clang_getTypeSpelling((CXType)type).getString());
    }

    public int[] getKinds() {
        return this.kinds;
    }

    public boolean isSpecial() {
        return this == POINTER || this == STRUCT || this == UNION || this == CLOSURE || this == ENUM || this == FIXED_SIZE_ARRAY;
    }

    public boolean isPrimitive() {
        return !this.isSpecial() && this != VOID;
    }

    public boolean isStackElement() {
        return this == STRUCT || this == UNION;
    }

    public boolean isSigned() {
        switch (this) {
            case SIGNED_BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case LONG_LONG: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
            case BOOLEAN: 
            case PROMOTED_BYTE: 
            case CHAR: 
            case PROMOTED_INT: 
            case PROMOTED_LONG: 
            case PROMOTED_LONG_LONG: {
                return false;
            }
        }
        throw new IllegalArgumentException("Type " + (Object)((Object)this) + " is not a primitive type");
    }

    public boolean hasPlatformDependentSize() {
        return this == LONG || this == PROMOTED_LONG;
    }

    public int getSize(PossibleTarget target) {
        switch (this) {
            case SIGNED_BYTE: 
            case BOOLEAN: 
            case PROMOTED_BYTE: 
            case NATIVE_BYTE: {
                return 1;
            }
            case SHORT: 
            case CHAR: {
                return 2;
            }
            case INT: 
            case FLOAT: 
            case PROMOTED_INT: {
                return 4;
            }
            case LONG: 
            case PROMOTED_LONG: {
                return target.is32Bit() || target.isWin() ? 4 : 8;
            }
            case LONG_LONG: 
            case DOUBLE: 
            case PROMOTED_LONG_LONG: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Type " + (Object)((Object)this) + " is not a primitive type");
    }

    public int getAlignment(PossibleTarget target) {
        switch (this) {
            case SIGNED_BYTE: 
            case BOOLEAN: 
            case PROMOTED_BYTE: 
            case NATIVE_BYTE: {
                return 1;
            }
            case SHORT: 
            case CHAR: {
                return 2;
            }
            case INT: 
            case FLOAT: 
            case PROMOTED_INT: {
                return 4;
            }
            case LONG: 
            case PROMOTED_LONG: {
                return target.is32Bit() || target.isWin() ? 4 : 8;
            }
            case LONG_LONG: 
            case DOUBLE: 
            case PROMOTED_LONG_LONG: {
                return target.isAndroidX86() ? 4 : 8;
            }
        }
        throw new IllegalArgumentException("Type " + (Object)((Object)this) + " is not a primitive type");
    }

    static {
        CACHE = TypeKind.values();
    }
}

