/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.gradle;

import com.badlogic.gdx.jnigen.BuildConfig;
import com.badlogic.gdx.jnigen.BuildTarget;
import com.badlogic.gdx.jnigen.FileDescriptor;
import com.badlogic.gdx.jnigen.RobovmBuildConfig;
import com.badlogic.gdx.jnigen.build.PlatformBuilder;
import com.badlogic.gdx.jnigen.commons.Os;
import com.badlogic.gdx.jnigen.gradle.JnigenExtension;
import java.util.Collections;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JnigenBuildTask
extends DefaultTask {
    private static final Logger logger = LoggerFactory.getLogger(JnigenBuildTask.class);
    private final JnigenExtension ext;
    private BuildTarget buildTarget;
    private Os osToBuild;

    @Inject
    public JnigenBuildTask(JnigenExtension ext) {
        this.ext = ext;
        this.setGroup("jnigen");
        this.setDescription("Builds native libraries");
    }

    public void setBuildTarget(BuildTarget buildTarget) {
        this.buildTarget = buildTarget;
    }

    public void setOsToBuild(Os osToBuild) {
        this.osToBuild = osToBuild;
    }

    @TaskAction
    public void run() {
        RobovmBuildConfig robovmBuildConfig = new RobovmBuildConfig();
        if (this.ext.robovm != null) {
            this.ext.robovm.execute((Object)robovmBuildConfig);
        }
        BuildConfig buildConfig = new BuildConfig(this.ext.sharedLibName, this.ext.subProjectDir + this.ext.temporaryDir, this.ext.subProjectDir + this.ext.libsDir, this.ext.subProjectDir + this.ext.jniDir, robovmBuildConfig, new FileDescriptor(this.ext.subProjectDir));
        buildConfig.multiThreadedCompile = this.ext.multiThreadedCompile;
        PlatformBuilder platformBuilder = new PlatformBuilder();
        if (this.buildTarget != null) {
            platformBuilder.build(this.buildTarget.os, buildConfig, Collections.singletonList(this.buildTarget));
        } else {
            platformBuilder.build(this.osToBuild, buildConfig, this.ext.targets);
        }
    }
}

