/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.gradle;

import com.badlogic.gdx.jnigen.BuildTarget;
import com.badlogic.gdx.jnigen.RobovmBuildConfig;
import com.badlogic.gdx.jnigen.commons.AndroidABI;
import com.badlogic.gdx.jnigen.commons.Architecture;
import com.badlogic.gdx.jnigen.commons.CompilerABIType;
import com.badlogic.gdx.jnigen.commons.HostDetection;
import com.badlogic.gdx.jnigen.commons.Os;
import com.badlogic.gdx.jnigen.commons.Platform;
import com.badlogic.gdx.jnigen.commons.TargetType;
import com.badlogic.gdx.jnigen.gradle.JnigenBindingGeneratorExtension;
import com.badlogic.gdx.jnigen.gradle.JnigenBuildTask;
import com.badlogic.gdx.jnigen.gradle.JnigenGenerateBindingsTask;
import com.badlogic.gdx.jnigen.gradle.JnigenPackageTask;
import com.badlogic.gdx.jnigen.gradle.JnigenSignTask;
import com.badlogic.gdx.jnigen.gradle.JnigenSigningExtension;
import com.badlogic.gdx.jnigen.gradle.JnigenTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JnigenExtension {
    private static final Logger log = LoggerFactory.getLogger(JnigenExtension.class);
    public static final Architecture.Bitness x32 = Architecture.Bitness._32;
    public static final Architecture.Bitness x64 = Architecture.Bitness._64;
    public static final Architecture.Bitness x128 = Architecture.Bitness._128;
    public static final Architecture x86 = Architecture.x86;
    public static final Architecture ARM = Architecture.ARM;
    public static final Architecture RISCV = Architecture.RISCV;
    public static final Architecture LOONGARCH = Architecture.LOONGARCH;
    public static final CompilerABIType MSVC = CompilerABIType.MSVC;
    public static final CompilerABIType GCC_CLANG = CompilerABIType.GCC_CLANG;
    public static final Os Windows = Os.Windows;
    public static final Os Linux = Os.Linux;
    public static final Os MacOsX = Os.MacOsX;
    public static final Os Android = Os.Android;
    public static final Os IOS = Os.IOS;
    public static final AndroidABI ABI_ARMEABI_V7A = AndroidABI.ABI_ARMEABI_V7A;
    public static final AndroidABI ABI_x86f = AndroidABI.ABI_x86;
    public static final AndroidABI ABI_ARM64_V8A = AndroidABI.ABI_ARM64_V8A;
    public static final AndroidABI ABI_x86_64 = AndroidABI.ABI_x86_64;
    public static final TargetType DEVICE = TargetType.DEVICE;
    public static final TargetType SIMULATOR = TargetType.SIMULATOR;
    final Project project;
    public String subProjectDir;
    public String sharedLibName = null;
    public String temporaryDir = "build/jnigen/target";
    public String libsDir = "build/jnigen/libs";
    public String jniDir = "build/jnigen/jni";
    public boolean release = true;
    public boolean multiThreadedCompile = true;
    NativeCodeGeneratorConfig nativeCodeGeneratorConfig;
    public List<BuildTarget> targets = new ArrayList<BuildTarget>();
    private Map<BuildTarget, Action<BuildTarget>> targetConfigurationMap = new HashMap<BuildTarget, Action<BuildTarget>>();
    private List<PredicateContainer> eachContainerPredicates = new ArrayList<PredicateContainer>();
    Action<BuildTarget> all = null;
    Action<RobovmBuildConfig> robovm;
    JnigenBindingGeneratorExtension generator;
    JnigenSigningExtension signing;
    DefaultTask signAllTask;
    private Set<Os> osLevelTargetsSeen = new HashSet<Os>();
    private Map<Platform, JnigenPackageTask> platformLevelTargetsSeen = new HashMap<Platform, JnigenPackageTask>();

    @Inject
    public JnigenExtension(Project project) {
        this.project = project;
        this.subProjectDir = project.getProjectDir().getAbsolutePath() + File.separator;
        this.nativeCodeGeneratorConfig = new NativeCodeGeneratorConfig(project);
        project.afterEvaluate(p -> this.targets.forEach(target -> {
            if (this.all != null) {
                this.all.execute(target);
            }
            if (this.targetConfigurationMap.containsKey(target)) {
                this.targetConfigurationMap.get(target).execute(target);
            }
            this.eachContainerPredicates.forEach(predicateContainer -> {
                if (predicateContainer.predicate.test((BuildTarget)target)) {
                    predicateContainer.container.execute(target);
                }
            });
        }));
    }

    public void generator(Action<JnigenBindingGeneratorExtension> container) {
        if (this.generator != null) {
            throw new IllegalStateException("generator already configured");
        }
        this.generator = new JnigenBindingGeneratorExtension();
        container.execute((Object)this.generator);
        this.project.getTasks().create("jnigenGenerateBindings", JnigenGenerateBindingsTask.class, new Object[]{this.generator});
    }

    public void nativeCodeGenerator(Action<NativeCodeGeneratorConfig> container) {
        container.execute((Object)this.nativeCodeGeneratorConfig);
    }

    public void signing(Action<JnigenSigningExtension> container) {
        if (this.signing != null) {
            throw new IllegalStateException("signing already configured");
        }
        this.signing = new JnigenSigningExtension();
        container.execute((Object)this.signing);
        this.signAllTask = (DefaultTask)this.project.getTasks().create("jnigenSignAll", DefaultTask.class);
        this.signAllTask.setGroup("jnigen");
        this.signAllTask.setDescription("Signs all signable native libraries");
    }

    public void all(Action<BuildTarget> container) {
        this.all = container;
    }

    public void robovm(Action<RobovmBuildConfig> robovmConfigContainer) {
        this.robovm = robovmConfigContainer;
    }

    public void addLinux(Architecture.Bitness bitness, Architecture architecture) {
        this.addLinux(bitness, architecture, null);
    }

    public void addLinux(Architecture.Bitness bitness, Architecture architecture, Action<BuildTarget> container) {
        this.add(Linux, bitness, architecture, CompilerABIType.GCC_CLANG, TargetType.DEVICE, null, container);
    }

    public void addIOS() {
        this.addIOS(x64, x86, SIMULATOR);
        this.addIOS(x64, ARM, DEVICE);
        this.addIOS(x64, ARM, SIMULATOR);
    }

    public void addIOS(Action<BuildTarget> container) {
        this.addIOS(x64, x86, SIMULATOR, container);
        this.addIOS(x64, ARM, DEVICE, container);
        this.addIOS(x64, ARM, SIMULATOR, container);
    }

    public void addIOS(Architecture.Bitness bitness, Architecture architecture, TargetType targetType) {
        this.addIOS(bitness, architecture, targetType, null);
    }

    public void addIOS(Architecture.Bitness bitness, Architecture architecture, TargetType targetType, Action<BuildTarget> container) {
        this.add(Os.IOS, bitness, architecture, CompilerABIType.GCC_CLANG, targetType, null, container);
    }

    public void addMac(Architecture.Bitness bitness, Architecture architecture) {
        this.addMac(bitness, architecture, null);
    }

    public void addMac(Architecture.Bitness bitness, Architecture architecture, Action<BuildTarget> container) {
        this.add(Os.MacOsX, bitness, architecture, GCC_CLANG, TargetType.DEVICE, null, container);
    }

    public void addWindows(Architecture.Bitness bitness, Architecture architecture) {
        this.addWindows(bitness, architecture, GCC_CLANG, null);
    }

    public void addWindows(Architecture.Bitness bitness, Architecture architecture, Action<BuildTarget> container) {
        this.addWindows(bitness, architecture, GCC_CLANG, container);
    }

    public void addWindows(Architecture.Bitness bitness, Architecture architecture, CompilerABIType compilerABIType) {
        this.addWindows(bitness, architecture, compilerABIType, null);
    }

    public void addWindows(Architecture.Bitness bitness, Architecture architecture, CompilerABIType compilerABIType, Action<BuildTarget> container) {
        this.add(Os.Windows, bitness, architecture, compilerABIType, TargetType.DEVICE, null, container);
    }

    public void addAndroid() {
        this.addAndroid(null, null);
    }

    public void addAndroid(Action<BuildTarget> container) {
        this.addAndroid(null, container);
    }

    public void addAndroid(AndroidABI abi) {
        this.addAndroid(abi, null);
    }

    public void addAndroid(AndroidABI abi, Action<BuildTarget> container) {
        if (abi == null) {
            for (AndroidABI value : AndroidABI.values()) {
                this.addAndroid(value, container);
            }
        } else {
            this.add(Os.Android, Architecture.Bitness._32, Architecture.x86, CompilerABIType.GCC_CLANG, DEVICE, abi, container);
        }
    }

    public void add(Os targetOs, Architecture.Bitness bitness, Architecture architecture, CompilerABIType abiType, TargetType targetType, AndroidABI androidABI, Action<BuildTarget> container) {
        String name = targetOs + architecture.toSuffix().toUpperCase() + bitness.toSuffix();
        if (this.get(targetOs, bitness, architecture, androidABI, targetType) != null) {
            throw new RuntimeException("Attempt to add duplicate build target " + name);
        }
        if (targetOs == Android && bitness != Architecture.Bitness._32 && architecture != Architecture.x86) {
            throw new RuntimeException("Android and iOS must not have is64Bit or isARM or isRISCV.");
        }
        BuildTarget target = BuildTarget.newDefaultTarget((Os)targetOs, (Architecture.Bitness)bitness, (Architecture)architecture, (CompilerABIType)abiType, (TargetType)targetType);
        target.release = this.release;
        this.targets.add(target);
        if (container != null) {
            this.targetConfigurationMap.put(target, container);
        }
        target.setAndroidOverrideABI(androidABI);
        this.checkForTasksToAdd(target);
    }

    private void checkForTasksToAdd(BuildTarget target) {
        JnigenBuildTask jnigenBuildTask;
        Os os = target.os;
        Platform platform = os.getPlatform();
        Architecture architecture = target.architecture;
        Architecture.Bitness bitness = target.bitness;
        JnigenTask jnigenTask = (JnigenTask)this.project.getTasks().getByName("jnigen");
        if (!this.platformLevelTargetsSeen.containsKey(platform)) {
            JnigenPackageTask jnigenPackageTask = (JnigenPackageTask)this.project.getTasks().create("jnigenPackageAll" + platform.name(), JnigenPackageTask.class, new Object[]{this});
            jnigenPackageTask.configure(null, platform);
            this.platformLevelTargetsSeen.put(platform, jnigenPackageTask);
        }
        if (!this.osLevelTargetsSeen.contains(os)) {
            this.osLevelTargetsSeen.add(os);
            jnigenBuildTask = (JnigenBuildTask)this.project.getTasks().create("jnigenBuildAll" + os.name(), JnigenBuildTask.class, new Object[]{this});
            jnigenBuildTask.setOsToBuild(os);
            jnigenBuildTask.dependsOn(new Object[]{jnigenTask});
            this.platformLevelTargetsSeen.get(platform).mustRunAfter(new Object[]{jnigenBuildTask});
        }
        if (target.os == Android) {
            jnigenBuildTask = (JnigenBuildTask)this.project.getTasks().create("jnigenBuild" + os.name() + "_" + target.getTargetAndroidABI().getAbiString(), JnigenBuildTask.class, new Object[]{this});
            jnigenBuildTask.setBuildTarget(target);
            jnigenBuildTask.dependsOn(new Object[]{jnigenTask});
            JnigenPackageTask jnigenPackageTask = (JnigenPackageTask)this.project.getTasks().create("jnigenPackage" + platform.name() + "_" + target.getTargetAndroidABI().getAbiString(), JnigenPackageTask.class, new Object[]{this});
            jnigenPackageTask.configure(target.getTargetAndroidABI(), platform);
            jnigenPackageTask.mustRunAfter(new Object[]{jnigenBuildTask});
            this.platformLevelTargetsSeen.get(platform).mustRunAfter(new Object[]{jnigenBuildTask});
        } else if (target.os != Os.IOS) {
            jnigenBuildTask = (JnigenBuildTask)this.project.getTasks().create("jnigenBuild" + os.name() + "_" + architecture.getDisplayName() + bitness.name(), JnigenBuildTask.class, new Object[]{this});
            jnigenBuildTask.setBuildTarget(target);
            jnigenBuildTask.dependsOn(new Object[]{jnigenTask});
            if (this.signing != null && (os == Windows && this.signing.getJsignParams() != null || (os == MacOsX || os == IOS) && this.signing.getIdentity() != null)) {
                JnigenSignTask jnigenSignTask = (JnigenSignTask)this.project.getTasks().create("jnigenSign" + os.name() + "_" + architecture.getDisplayName() + bitness.name(), JnigenSignTask.class, new Object[]{this});
                jnigenSignTask.setBuildTarget(target);
                jnigenSignTask.dependsOn(new Object[]{jnigenBuildTask});
                this.signAllTask.dependsOn(new Object[]{jnigenSignTask});
            }
            this.platformLevelTargetsSeen.get(platform).mustRunAfter(new Object[]{jnigenBuildTask});
            if (HostDetection.os == os && HostDetection.architecture == architecture && HostDetection.bitness == bitness) {
                DefaultTask hostTask = (DefaultTask)this.project.getTasks().create("jnigenBuildHost", DefaultTask.class);
                hostTask.dependsOn(new Object[]{jnigenBuildTask});
                hostTask.setGroup("jnigen");
                hostTask.setDescription("Builds only the host architecture");
            }
        }
    }

    private BuildTarget get(Os type, Architecture.Bitness bitness, Architecture architecture, AndroidABI androidABI, TargetType targetType) {
        for (BuildTarget target : this.targets) {
            if (target.os != type || target.bitness != bitness || target.architecture != architecture || target.getTargetAndroidABI() != androidABI || target.targetType != targetType) continue;
            return target;
        }
        return null;
    }

    public void each(Predicate<BuildTarget> condition, Action<BuildTarget> container) {
        this.eachContainerPredicates.add(new PredicateContainer(condition, container));
    }

    public class NativeCodeGeneratorConfig {
        public SourceSet sourceSet;
        public String[] includes = null;
        public String[] excludes = null;
        private String[] sourceDirs;

        public NativeCodeGeneratorConfig(Project project) {
            JavaPluginExtension javaPlugin = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            SourceSetContainer sourceSets = javaPlugin.getSourceSets();
            this.sourceSet = (SourceSet)sourceSets.findByName("main");
        }

        public String toString() {
            return "NativeCodeGeneratorConfig[sourceDir=`" + Arrays.toString(this.sourceDirs) + "`, sourceSet=`" + this.sourceSet + "`, jniDir=`" + JnigenExtension.this.jniDir + "`, includes=`" + Arrays.toString(this.includes) + "`, excludes=`" + Arrays.toString(this.excludes) + "`]";
        }

        public void setSourceDirs(String[] sourceDirs) {
            this.sourceDirs = sourceDirs;
        }

        public String[] getSourceDirs() {
            if (this.sourceDirs != null) {
                return this.sourceDirs;
            }
            this.sourceDirs = (String[])this.sourceSet.getJava().getSrcDirs().stream().map(File::getPath).toArray(String[]::new);
            return this.sourceDirs;
        }
    }

    private static class PredicateContainer {
        Predicate<BuildTarget> predicate;
        Action<BuildTarget> container;

        PredicateContainer(Predicate<BuildTarget> predicate, Action<BuildTarget> container) {
            this.predicate = predicate;
            this.container = container;
        }
    }
}

