/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.gradle;

import com.badlogic.gdx.jnigen.gradle.JnigenBindingGeneratorExtension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.JavaExecSpec;

public class JnigenGenerateBindingsTask
extends DefaultTask {
    private final JnigenBindingGeneratorExtension generator;
    private Configuration configuration;

    @Inject
    public JnigenGenerateBindingsTask(JnigenBindingGeneratorExtension generator) {
        this.generator = generator;
        this.setGroup("jnigen");
        this.setDescription("Generates java jnigen binding code.");
        Configuration llvmConfiguration = (Configuration)this.getProject().getConfigurations().create("generatorLLVM", conf -> {
            conf.setVisible(false);
            conf.setCanBeResolved(true);
            conf.setCanBeConsumed(false);
            conf.setDescription("LLVM dependencies for generator");
        });
        this.getProject().getDependencies().add("generatorLLVM", (Object)"org.bytedeco:llvm-platform:19.1.3-1.5.11");
        this.configuration = llvmConfiguration;
    }

    @Classpath
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @TaskAction
    public void run() {
        Objects.requireNonNull(this.generator.getOutputPath(), "jnigen.generator.outputPath not defined");
        Objects.requireNonNull(this.generator.getBasePackage(), "jnigen.generator.basePackage not defined");
        Objects.requireNonNull(this.generator.getFileToParse(), "jnigen.generator.fileToParse not defined");
        ConfigurableFileCollection filteredClasspath = this.getProject().files(new Object[]{this.getProject().getBuildscript().getConfigurations().getByName("classpath").resolve().stream().filter(file -> !file.getAbsolutePath().contains("gradle-")).collect(Collectors.toList())});
        String[] options = this.generator.getOptions();
        if (options == null) {
            options = new String[]{};
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.generator.getOutputPath().getAbsolutePath());
        args.add(this.generator.getBasePackage());
        args.add(this.generator.getFileToParse());
        args.addAll(Arrays.asList(options));
        this.getProject().javaexec(arg_0 -> this.lambda$run$2((FileCollection)filteredClasspath, args, arg_0));
    }

    private /* synthetic */ void lambda$run$2(FileCollection filteredClasspath, ArrayList args, JavaExecSpec spec) {
        spec.environment("LIBCLANG_DISABLE_CRASH_RECOVERY", (Object)"1");
        spec.setClasspath(filteredClasspath.plus((FileCollection)this.configuration));
        spec.getMainClass().set((Object)"com.badlogic.gdx.jnigen.generator.Generator");
        spec.args((Iterable)args);
    }
}

