/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.gradle;

import com.badlogic.gdx.jnigen.BuildConfig;
import com.badlogic.gdx.jnigen.FileDescriptor;
import com.badlogic.gdx.jnigen.RobovmBuildConfig;
import com.badlogic.gdx.jnigen.build.packaging.Packager;
import com.badlogic.gdx.jnigen.commons.AndroidABI;
import com.badlogic.gdx.jnigen.commons.Platform;
import com.badlogic.gdx.jnigen.gradle.JnigenExtension;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JnigenPackageTask
extends DefaultTask {
    private static final Logger log = LoggerFactory.getLogger(JnigenPackageTask.class);
    private JnigenExtension ext;
    private Platform[] platformsToPackage;
    @Nullable
    private AndroidABI targetAndroidABI;
    private Packager packager;

    @Inject
    public JnigenPackageTask(JnigenExtension ext) {
        this.ext = ext;
        this.setGroup("jnigen");
        this.setDescription("Packages all native libraries into a single Platform artifact");
    }

    public void configure(AndroidABI androidABIPackageOverride, Platform ... platformsToPackage) {
        this.platformsToPackage = platformsToPackage;
        this.targetAndroidABI = androidABIPackageOverride;
        this.packager = new Packager();
        List<String> outputs = this.getBuildOutputs();
        for (String output : outputs) {
            this.getOutputs().file((Object)(this.ext.subProjectDir + this.ext.libsDir + "/" + output));
        }
        this.getOutputs().upToDateWhen((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return false;
            }
        });
    }

    private List<String> getBuildOutputs() {
        ArrayList<String> outputs = new ArrayList<String>();
        block4: for (Platform platform : this.platformsToPackage) {
            if (platform == Platform.Android) {
                if (this.targetAndroidABI != null) {
                    outputs.add(this.ext.sharedLibName + "-natives-" + this.targetAndroidABI.getAbiString() + ".jar");
                    continue;
                }
                log.trace("No target AndroidABI set");
                continue;
            }
            switch (platform) {
                case Desktop: {
                    outputs.add(this.ext.sharedLibName + "-natives-desktop.jar");
                    continue block4;
                }
                case IOS: {
                    outputs.add(this.ext.sharedLibName + "-natives-ios.jar");
                }
            }
        }
        return outputs;
    }

    @TaskAction
    public void run() {
        RobovmBuildConfig robovmBuildConfig = new RobovmBuildConfig();
        if (this.ext.robovm != null) {
            this.ext.robovm.execute((Object)robovmBuildConfig);
        }
        BuildConfig buildConfig = new BuildConfig(this.ext.sharedLibName, this.ext.subProjectDir + this.ext.temporaryDir, this.ext.subProjectDir + this.ext.libsDir, this.ext.subProjectDir + this.ext.jniDir, robovmBuildConfig, new FileDescriptor(this.ext.subProjectDir));
        buildConfig.targetJarBaseName = this.ext.sharedLibName;
        buildConfig.errorOnPackageMissingNative = this.getProject().hasProperty("jnigen.packageErrorOnMissingNatives");
        for (Platform platform : this.platformsToPackage) {
            if (platform == Platform.Android && this.targetAndroidABI != null) {
                List filteredForABI = this.ext.targets.stream().filter(target -> target.os.getPlatform() == Platform.Android && target.getTargetAndroidABI() == this.targetAndroidABI).collect(Collectors.toList());
                this.packager.packagePlatform(platform, buildConfig, filteredForABI);
                continue;
            }
            this.packager.packagePlatform(platform, buildConfig, this.ext.targets);
        }
    }

    @Input
    public String getSharedLibName() {
        return this.ext.sharedLibName;
    }
}

