/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.gradle;

import com.badlogic.gdx.jnigen.BuildTarget;
import com.badlogic.gdx.jnigen.commons.AndroidABI;
import com.badlogic.gdx.jnigen.commons.Platform;
import com.badlogic.gdx.jnigen.gradle.JnigenExtension;
import com.badlogic.gdx.jnigen.gradle.JnigenGithubActionBuilderTask;
import com.badlogic.gdx.jnigen.gradle.JnigenPackageTask;
import com.badlogic.gdx.jnigen.gradle.JnigenTask;
import java.util.HashSet;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.publish.PublicationContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.MavenPublication;

public class JnigenPlugin
implements Plugin<Project> {
    public void apply(final Project project) {
        final JnigenExtension ext = (JnigenExtension)project.getExtensions().create("jnigen", JnigenExtension.class, new Object[]{project});
        JnigenTask jnigen = (JnigenTask)project.getTasks().create("jnigen", JnigenTask.class, new Object[]{ext});
        jnigen.dependsOn(new Object[]{project.getTasks().getByName("classes")});
        project.getTasks().create("jnigenGHA", JnigenGithubActionBuilderTask.class, new Object[]{ext});
        project.getGradle().projectsEvaluated((Action)new Action<Gradle>(){

            public void execute(Gradle gradle) {
                HashSet<Platform> platformsConfigured = new HashSet<Platform>();
                for (BuildTarget target : ext.targets) {
                    platformsConfigured.add(target.os.getPlatform());
                }
                int size = platformsConfigured.size();
                Platform[] platformsToBuild = new Platform[size];
                int index = 0;
                for (Platform platform : platformsConfigured) {
                    platformsToBuild[index++] = platform;
                }
                final JnigenPackageTask jnigenPackageTask = (JnigenPackageTask)project.getTasks().create("jnigenPackageAll", JnigenPackageTask.class, new Object[]{ext});
                jnigenPackageTask.configure(null, platformsToBuild);
                if (!project.getPlugins().hasPlugin("maven-publish")) {
                    return;
                }
                project.getPlugins().apply("maven-publish");
                project.getExtensions().configure(PublishingExtension.class, (Action)new Action<PublishingExtension>(){

                    public void execute(PublishingExtension publishingExtension) {
                        publishingExtension.publications((Action)new Action<PublicationContainer>(){

                            public void execute(PublicationContainer publications) {
                                publications.create("jniPlatform", MavenPublication.class, (Action)new Action<MavenPublication>(){

                                    public void execute(MavenPublication mavenPublication) {
                                        String archiveBaseName = jnigenPackageTask.getSharedLibName();
                                        mavenPublication.setArtifactId(archiveBaseName + "-platform");
                                        JnigenPlugin.this.safeAddMavenPublication("jnigenPackageAllDesktop", project, mavenPublication, "natives-desktop");
                                        for (AndroidABI abi : AndroidABI.values()) {
                                            JnigenPlugin.this.safeAddMavenPublication("jnigenPackageAndroid_" + abi.getAbiString(), project, mavenPublication, "natives-" + abi.getAbiString());
                                        }
                                        JnigenPlugin.this.safeAddMavenPublication("jnigenPackageAllIOS", project, mavenPublication, "natives-ios");
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    private void safeAddMavenPublication(String jniPackageTask, Project project, MavenPublication mavenPublication, final String classifier) {
        try {
            final JnigenPackageTask packageByName = (JnigenPackageTask)project.getTasks().getByName(jniPackageTask);
            mavenPublication.artifact((Object)packageByName.getOutputs().getFiles().getSingleFile(), (Action)new Action<MavenArtifact>(){

                public void execute(MavenArtifact mavenArtifact) {
                    mavenArtifact.setClassifier(classifier);
                    mavenArtifact.builtBy(new Object[]{packageByName});
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

