/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.gradle;

import com.badlogic.gdx.jnigen.BuildConfig;
import com.badlogic.gdx.jnigen.BuildTarget;
import com.badlogic.gdx.jnigen.FileDescriptor;
import com.badlogic.gdx.jnigen.build.RuntimeEnv;
import com.badlogic.gdx.jnigen.build.ToolFinder;
import com.badlogic.gdx.jnigen.build.ToolchainExecutor;
import com.badlogic.gdx.jnigen.gradle.JnigenExtension;
import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JnigenSignTask
extends DefaultTask {
    private static final Logger log = LoggerFactory.getLogger(JnigenSignTask.class);
    private final JnigenExtension ext;
    private BuildTarget buildTarget;

    @Inject
    public JnigenSignTask(JnigenExtension ext) {
        this.ext = ext;
        this.setGroup("jnigen");
        this.setDescription("Signs native libraries");
    }

    public void setBuildTarget(BuildTarget buildTarget) {
        this.buildTarget = buildTarget;
    }

    @TaskAction
    public void run() {
        BuildConfig buildConfig = new BuildConfig(this.ext.sharedLibName, this.ext.subProjectDir + this.ext.temporaryDir, this.ext.subProjectDir + this.ext.libsDir, this.ext.subProjectDir + this.ext.jniDir, null, new FileDescriptor(this.ext.subProjectDir));
        RuntimeEnv env = new RuntimeEnv();
        ArrayList<String> args = new ArrayList<String>();
        switch (this.buildTarget.os) {
            case Windows: {
                Map<String, String> params = this.ext.signing.getJsignParams();
                params.put("file", this.buildTarget.getTargetBinaryFile(buildConfig).getPath());
                Closure jsign = (Closure)this.ext.project.getExtensions().getByName("jsign");
                jsign.call(params);
                break;
            }
            case MacOsX: 
            case IOS: {
                File codesign = ToolFinder.getToolFile((String)"codesign", (RuntimeEnv)env, (boolean)true);
                args.add("-s");
                args.add(this.ext.signing.getIdentity());
                args.add("-f");
                args.add(this.buildTarget.getTargetBinaryFile(buildConfig).getPath());
                ToolchainExecutor.execute((File)codesign, (File)this.getProject().getProjectDir(), args, (ToolchainExecutor.ToolchainCallback)new ToolchainExecutor.ToolchainCallback(){

                    public void onInfoMessage(String message) {
                        log.info(message);
                    }

                    public void onErrorMessage(String message) {
                        log.error(message);
                    }

                    public void onSuccess() {
                        log.info("Signing successful");
                    }

                    public void onFail(int statusCode) {
                        log.error("Signing failed with status code: {}", (Object)statusCode);
                    }
                });
                break;
            }
            default: {
                log.warn("Signing not supported for {}", (Object)this.buildTarget.os);
            }
        }
    }
}

