/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.gradle;

import com.badlogic.gdx.jnigen.FileDescriptor;
import com.badlogic.gdx.jnigen.NativeCodeGenerator;
import com.badlogic.gdx.jnigen.build.PlatformBuilder;
import com.badlogic.gdx.jnigen.gradle.JnigenExtension;
import java.util.Arrays;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JnigenTask
extends DefaultTask {
    private static final Logger log = LoggerFactory.getLogger(JnigenTask.class);
    JnigenExtension ext;

    @Inject
    public JnigenTask(JnigenExtension ext) {
        this.ext = ext;
        this.setGroup("jnigen");
        this.setDescription("Generates jnigen native code files and build scripts.");
        this.getProject().afterEvaluate(project -> this.dependsOn(new Object[]{ext.nativeCodeGeneratorConfig.sourceSet.getRuntimeClasspath()}));
    }

    @TaskAction
    public void run() {
        if (this.ext.sharedLibName == null) {
            log.error("sharedLibName must be defined");
            throw new RuntimeException("sharedLibName must be defined");
        }
        log.debug("subProjectDir {}", (Object)this.ext.subProjectDir);
        log.debug("sharedLibName {}", (Object)this.ext.sharedLibName);
        log.debug("nativeCodeGeneratorConfig {}", (Object)this.ext.nativeCodeGeneratorConfig);
        FileDescriptor headerDestination = new FileDescriptor(this.ext.subProjectDir).child(this.ext.jniDir);
        PlatformBuilder.copyHeaders((FileDescriptor)headerDestination);
        Arrays.stream(this.ext.nativeCodeGeneratorConfig.getSourceDirs()).map(s -> s.startsWith(this.ext.subProjectDir) ? s : this.ext.subProjectDir + s).forEach(s -> {
            try {
                new NativeCodeGenerator().generate(s, this.ext.nativeCodeGeneratorConfig.sourceSet.getRuntimeClasspath().getAsPath(), this.ext.subProjectDir + this.ext.jniDir, this.ext.nativeCodeGeneratorConfig.includes, this.ext.nativeCodeGeneratorConfig.excludes);
            }
            catch (Exception e) {
                throw new RuntimeException("NativeCodeGenerator threw exception", e);
            }
        });
    }
}

