/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.runtime;

import com.badlogic.gdx.jnigen.loader.SharedLibraryLoader;
import com.badlogic.gdx.jnigen.runtime.c.CTypeInfo;
import com.badlogic.gdx.jnigen.runtime.c.CXXException;
import com.badlogic.gdx.jnigen.runtime.closure.Closure;
import com.badlogic.gdx.jnigen.runtime.closure.ClosureDecoder;
import com.badlogic.gdx.jnigen.runtime.closure.ClosureObject;
import com.badlogic.gdx.jnigen.runtime.closure.JavaClosureObject;
import com.badlogic.gdx.jnigen.runtime.mem.AllocationManager;
import com.badlogic.gdx.jnigen.runtime.mem.BufferPtr;
import com.badlogic.gdx.jnigen.runtime.mem.BufferPtrManager;
import com.badlogic.gdx.jnigen.runtime.util.DowncallCClosureObjectSupplier;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;

public class CHandler {
    public static final int POINTER_SIZE;
    public static final boolean IS_32_BIT;
    public static final boolean IS_64_BIT;
    public static final boolean IS_COMPILED_UNIX;
    public static final boolean IS_COMPILED_WIN;
    public static final boolean IS_COMPILED_ANDROID_X86;
    public static final boolean IS_CHAR_SIGNED;
    public static final int LONG_SIZE;
    private static final HashMap<CTypeInfo[], Long> classCifMap;
    private static final HashMap<Long, ClosureObject<?>> fnPtrClosureMap;

    public static void init() {
    }

    private static native boolean is32Bit();

    private static native boolean isCompiledWin();

    private static native boolean isCompiledAndroidX86();

    private static native boolean isCharSigned();

    private static native boolean init(Method var0, Method var1);

    public static String getExceptionString(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private static void testNativeSetup() {
        try {
            CHandler.testIllegalArgumentExceptionThrowable(IllegalArgumentException.class);
            throw new RuntimeException("Unable to throw IllegalArgumentException from JNI.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                CHandler.testCXXExceptionThrowable(CXXException.class);
                throw new RuntimeException("Unable to throw CXXException from JNI.");
            }
            catch (CXXException cXXException) {
                return;
            }
        }
    }

    private static native void testIllegalArgumentExceptionThrowable(Class<?> var0);

    private static native void testCXXExceptionThrowable(Class<?> var0);

    public static native void setDisableCXXExceptionMessage(boolean var0);

    public static native boolean reExportSymbolsGlobally(String var0);

    public static <T extends Closure> void dispatchCallback(ClosureDecoder<T> toCallOn, long parameter) {
        BufferPtr ptr = AllocationManager.wrap(parameter);
        toCallOn.invoke(ptr);
        BufferPtrManager.insertPool(ptr);
    }

    public static native void dispatchCCall(long var0, long var2, long var4);

    public static native long convertNativeTypeToFFIType(long var0);

    public static CTypeInfo constructCTypeFromNativeType(long nativeType) {
        if (nativeType == 0L) {
            throw new IllegalArgumentException("CType maps to zero.");
        }
        long ffiType = CHandler.convertNativeTypeToFFIType(nativeType);
        return new CTypeInfo(ffiType, CHandler.getSizeFromFFIType(ffiType));
    }

    private static native long nativeCreateCif(long var0, ByteBuffer var2, int var3);

    private static long generateFFICifForSignature(CTypeInfo[] signature) {
        int parameterCount = signature.length - 1;
        ByteBuffer mappedParameter = ByteBuffer.allocateDirect(parameterCount * 8);
        mappedParameter.order(ByteOrder.nativeOrder());
        for (int i = 1; i < signature.length; ++i) {
            mappedParameter.putLong((i - 1) * 8, signature[i].getFfiType());
        }
        return CHandler.nativeCreateCif(signature[0].getFfiType(), mappedParameter, parameterCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getFFICifForSignature(CTypeInfo[] signature) {
        HashMap<CTypeInfo[], Long> hashMap = classCifMap;
        synchronized (hashMap) {
            Long cif = classCifMap.get(signature);
            if (cif == null) {
                cif = CHandler.generateFFICifForSignature(signature);
                classCifMap.put(signature, cif);
            }
            return cif;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Closure> ClosureObject<T> createClosureForObject(T object) {
        long cif = CHandler.getFFICifForSignature(object.functionSignature());
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.nativeOrder());
        ClosureDecoder<T> closureDecoder = new ClosureDecoder<T>(object);
        long fnPtr = CHandler.createClosureForObject(cif, closureDecoder, byteBuffer);
        long closurePtr = byteBuffer.getLong();
        JavaClosureObject<T> closureObject = new JavaClosureObject<T>(object, fnPtr, closurePtr, closureDecoder);
        HashMap<Long, ClosureObject<?>> hashMap = fnPtrClosureMap;
        synchronized (hashMap) {
            fnPtrClosureMap.put(fnPtr, closureObject);
        }
        return closureObject;
    }

    public static native <T extends Closure> long createClosureForObject(long var0, ClosureDecoder<T> var2, ByteBuffer var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Closure> ClosureObject<T> getClosureObject(long fnPtr, DowncallCClosureObjectSupplier<T> closureFallback) {
        HashMap<Long, ClosureObject<?>> hashMap = fnPtrClosureMap;
        synchronized (hashMap) {
            ClosureObject<?> closureObject = fnPtrClosureMap.get(fnPtr);
            if (closureObject == null) {
                if (closureFallback == null) {
                    throw new RuntimeException("No Closure object found for " + fnPtr);
                }
                closureObject = closureFallback.get(fnPtr);
                fnPtrClosureMap.put(fnPtr, closureObject);
            }
            return closureObject;
        }
    }

    public static native ByteBuffer wrapPointer(long var0, int var2);

    public static native int getSizeFromFFIType(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterFunctionPointer(long fnPtr) {
        HashMap<Long, ClosureObject<?>> hashMap = fnPtrClosureMap;
        synchronized (hashMap) {
            fnPtrClosureMap.remove(fnPtr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearRegisteredFunctionPointer() {
        HashMap<Long, ClosureObject<?>> hashMap = fnPtrClosureMap;
        synchronized (hashMap) {
            fnPtrClosureMap.clear();
        }
    }

    public static native void freeClosure(long var0);

    public static native long malloc(long var0);

    public static native long calloc(long var0, long var2);

    public static native void free(long var0);

    public static native void memcpy(long var0, long var2, long var4);

    public static native long clone(long var0, long var2);

    static {
        new SharedLibraryLoader().load("jnigen-runtime");
        try {
            boolean res = CHandler.init(CHandler.class.getDeclaredMethod("dispatchCallback", ClosureDecoder.class, Long.TYPE), CHandler.class.getDeclaredMethod("getExceptionString", Throwable.class));
            if (!res) {
                throw new RuntimeException("JNI initialization failed, either CHandler#dispatchCallback or CHandler#getExceptionString are not JNI accessible.");
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        POINTER_SIZE = CHandler.is32Bit() ? 4 : 8;
        IS_32_BIT = CHandler.is32Bit();
        IS_64_BIT = !CHandler.is32Bit();
        IS_COMPILED_UNIX = !CHandler.isCompiledWin();
        IS_COMPILED_WIN = CHandler.isCompiledWin();
        IS_COMPILED_ANDROID_X86 = CHandler.isCompiledAndroidX86();
        IS_CHAR_SIGNED = CHandler.isCharSigned();
        LONG_SIZE = CHandler.is32Bit() || CHandler.isCompiledWin() ? 4 : 8;
        CHandler.testNativeSetup();
        classCifMap = new HashMap();
        fnPtrClosureMap = new HashMap();
    }
}

