/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.runtime.closure;

import com.badlogic.gdx.jnigen.runtime.CHandler;
import com.badlogic.gdx.jnigen.runtime.closure.Closure;
import com.badlogic.gdx.jnigen.runtime.closure.ClosureDecoder;
import com.badlogic.gdx.jnigen.runtime.closure.ClosureObject;
import com.badlogic.gdx.jnigen.runtime.closure.PointingPoolManager;

public class JavaClosureObject<T extends Closure>
extends ClosureObject<T> {
    private final long closurePtr;
    private final ClosureDecoder<T> decoder;
    private boolean freed;

    public JavaClosureObject(T closure, long fnPtr, long closurePtr, ClosureDecoder<T> decoder) {
        super(closure, fnPtr);
        this.closurePtr = closurePtr;
        this.decoder = decoder;
    }

    @Override
    public void free() {
        if (this.freed) {
            throw new IllegalArgumentException("Closure already freed");
        }
        CHandler.deregisterFunctionPointer(this.getPointer());
        CHandler.freeClosure(this.closurePtr);
        this.freed = true;
    }

    @Override
    public void setPoolManager(PointingPoolManager manager) {
        this.decoder.setPoolManager(manager);
    }

    public long getClosurePtr() {
        return this.closurePtr;
    }
}

