/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.runtime.closure;

import com.badlogic.gdx.jnigen.runtime.pointer.PointerDereferenceSupplier;
import com.badlogic.gdx.jnigen.runtime.pointer.PointerPointer;
import com.badlogic.gdx.jnigen.runtime.pointer.Pointing;
import com.badlogic.gdx.jnigen.runtime.pointer.PointingPool;
import com.badlogic.gdx.jnigen.runtime.pointer.StackElement;
import java.util.HashMap;

public class PointingPoolManager {
    private final HashMap<Class<?>, PointingPool<?>> pools = new HashMap();
    private final Pointing[] frame;
    private int count;

    public PointingPoolManager(int size) {
        this.frame = new Pointing[size];
    }

    public <T extends Pointing> T poll(Class<T> clazz) {
        if (this.count >= this.frame.length) {
            throw new IllegalStateException("Pooled objects exceed max size of " + this.frame.length);
        }
        PointingPool<?> pool = this.pools.get(clazz);
        if (pool == null) {
            throw new IllegalArgumentException("No PointingPool found for " + clazz);
        }
        Object obj = pool.pollOrCreate();
        this.frame[this.count++] = obj;
        return (T)obj;
    }

    public <T extends Pointing> T getPointing(Class<T> clazz, long ptr) {
        if (PointerPointer.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Call getPointerPointer to retrieve a PointerPointer");
        }
        T pointing = this.poll(clazz);
        ((Pointing)pointing).setPointer(ptr);
        return pointing;
    }

    public <S extends Pointing, T extends PointerPointer<S>> T getPointerPointer(Class<T> clazz, long ptr, PointerDereferenceSupplier<S> supplier) {
        PointerPointer pointing = (PointerPointer)this.poll(clazz);
        pointing.setPointer(ptr);
        pointing.setPointerSupplier(supplier);
        return (T)pointing;
    }

    public <T extends Pointing> void addPool(PointerDereferenceSupplier<T> supplier, int capacity) {
        PointingPool<T> pool = new PointingPool<T>(capacity, supplier);
        this.addPool(pool);
    }

    public <T extends Pointing> void addPool(PointingPool<T> pool) {
        Object obj = pool.pollOrCreate();
        this.pools.put(obj.getClass(), pool);
        pool.offer(obj);
    }

    public void flush() {
        for (int i = 0; i < this.count; ++i) {
            Pointing obj = this.frame[i];
            if (obj instanceof StackElement) {
                obj.free();
            }
            PointingPool<?> pool = this.pools.get(obj.getClass());
            pool.offer(obj);
            this.frame[i] = null;
        }
        this.count = 0;
    }
}

