/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.runtime.gc;

import com.badlogic.gdx.jnigen.runtime.gc.PointingPhantomReference;
import com.badlogic.gdx.jnigen.runtime.gc.ReferenceList;
import com.badlogic.gdx.jnigen.runtime.mem.BufferPtr;
import com.badlogic.gdx.jnigen.runtime.mem.BufferPtrManager;
import com.badlogic.gdx.jnigen.runtime.pointer.Pointing;
import java.lang.ref.ReferenceQueue;

public class GCHandler {
    private static final boolean NO_GC_FREE = System.getProperty("com.badlogic.jnigen.gc.gc_disabled", "false").equals("true");
    private static final boolean ENABLE_GC_LOG = System.getProperty("com.badlogic.jnigen.gc.gc_log", "false").equals("true");
    protected static final ReferenceQueue<Pointing> REFERENCE_QUEUE = new ReferenceQueue();
    private static final ReferenceList referenceList = new ReferenceList();
    private static final Thread RELEASER = new Thread(){

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        PointingPhantomReference pointingRef = (PointingPhantomReference)REFERENCE_QUEUE.remove();
                        referenceList.removeReference(pointingRef);
                        if (ENABLE_GC_LOG) {
                            System.out.println("Freeing Pointer: " + pointingRef.getBufferPtr().getPointer());
                        }
                        pointingRef.getBufferPtr().free();
                        BufferPtrManager.insertPool(pointingRef.getBufferPtr());
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    };

    public static void enqueuePointer(Pointing pointing, BufferPtr bufferPtr) {
        if (NO_GC_FREE) {
            return;
        }
        if (ENABLE_GC_LOG) {
            System.out.println("Enqueuing Pointer: " + pointing.getPointer() + " of class " + pointing.getClass());
        }
        if (pointing.isNull()) {
            return;
        }
        PointingPhantomReference structPhantomReference = new PointingPhantomReference(pointing, bufferPtr);
        referenceList.insertReference(structPhantomReference);
    }

    public static long nativeObjectCount() {
        return referenceList.getSize();
    }

    static {
        RELEASER.setDaemon(true);
        RELEASER.setName("jnigen-releaser");
        RELEASER.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                e.printStackTrace();
                System.exit(1);
            }
        });
        RELEASER.start();
    }
}

