/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.runtime.gc;

import com.badlogic.gdx.jnigen.runtime.gc.PointingPhantomReference;

public final class ReferenceList {
    private ReferenceListNode head = new ReferenceListNode();
    private ReferenceListNode poolCache;
    private long size;

    public synchronized void insertReference(PointingPhantomReference reference) {
        if (this.head.size >= 4096) {
            if (this.poolCache != null) {
                this.poolCache.next = this.head;
                this.head = this.poolCache;
                this.poolCache = null;
            } else {
                ReferenceListNode newHead = new ReferenceListNode();
                newHead.next = this.head;
                this.head = newHead;
            }
        }
        this.head.addNode(reference);
        ++this.size;
    }

    public synchronized void removeReference(PointingPhantomReference reference) {
        PointingPhantomReference headLastNode = this.head.getLastNode();
        if (headLastNode != reference) {
            reference.getNode().setNode(headLastNode, reference.getPosition());
        }
        this.head.removeLastNode();
        if (this.head.size == 0 && this.head.next != null) {
            if (this.poolCache == null) {
                this.poolCache = this.head;
            }
            this.head = this.head.next;
        }
        --this.size;
    }

    public long getSize() {
        return this.size;
    }

    public static final class ReferenceListNode {
        private static final int NODE_SIZE = 4096;
        private final PointingPhantomReference[] elements = new PointingPhantomReference[4096];
        private int size = 0;
        private ReferenceListNode next = null;

        public void addNode(PointingPhantomReference reference) {
            reference.setNode(this);
            reference.setPosition(this.size);
            this.elements[this.size] = reference;
            ++this.size;
        }

        public void setNode(PointingPhantomReference reference, int position) {
            reference.setPosition(position);
            reference.setNode(this);
            this.elements[position] = reference;
        }

        public PointingPhantomReference getLastNode() {
            return this.elements[this.size - 1];
        }

        public void removeLastNode() {
            this.elements[this.size - 1] = null;
            --this.size;
        }
    }
}

