/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.runtime.mem;

import com.badlogic.gdx.jnigen.runtime.CHandler;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class BufferPtr {
    private ByteBuffer buffer;
    private long pointer;
    private int offset;
    private int capacity;

    public BufferPtr() {
    }

    public BufferPtr(ByteBuffer buffer, long pointer, int offset, int capacity) {
        this.buffer = buffer;
        this.pointer = pointer;
        this.offset = offset;
        this.capacity = capacity;
        if (capacity > buffer.capacity() - offset) {
            throw new IllegalArgumentException("Buffer capacity (" + buffer.capacity() + ") exceeded by " + capacity + ". More then 1GB?");
        }
    }

    void reset(ByteBuffer buffer, long pointer, int offset, int capacity) {
        this.buffer = buffer;
        this.pointer = pointer;
        this.offset = offset;
        this.capacity = capacity;
        if (buffer != null && capacity > buffer.capacity() - offset) {
            throw new IllegalArgumentException("Buffer capacity (" + buffer.capacity() + ") exceeded by " + capacity + ". More then 1GB?");
        }
    }

    public void free() {
        if (this.buffer == null) {
            throw new IllegalStateException("Buffer invalid (use-after-free?)");
        }
        if (this.isNull()) {
            throw new NullPointerException("Buffer is null");
        }
        CHandler.free(this.pointer);
        this.reset(null, 0L, 0, 0);
    }

    public void assertBounds(int expectedCapacity) {
        if (this.buffer == null) {
            throw new IllegalStateException("Buffer invalid (use-after-free?)");
        }
        if (this.isNull()) {
            throw new NullPointerException("Buffer is null");
        }
        if (this.hasCapacity() && (expectedCapacity < 0 || expectedCapacity > this.capacity)) {
            throw new IndexOutOfBoundsException("Index: " + expectedCapacity + ", Size: " + this.capacity);
        }
    }

    public boolean getBoolean() {
        this.assertBounds(1);
        return this.buffer.get(this.offset) != 0;
    }

    public boolean getBoolean(int index) {
        this.assertBounds(index + 1);
        return this.buffer.get(this.offset + index) != 0;
    }

    public void setBoolean(boolean value) {
        this.assertBounds(1);
        this.buffer.put(this.offset, (byte)(value ? 1 : 0));
    }

    public void setBoolean(int index, boolean value) {
        this.assertBounds(index + 1);
        this.buffer.put(this.offset + index, (byte)(value ? 1 : 0));
    }

    public byte getByte() {
        this.assertBounds(1);
        return this.buffer.get(this.offset);
    }

    public byte getByte(int index) {
        this.assertBounds(index + 1);
        return this.buffer.get(this.offset + index);
    }

    public void setByte(byte value) {
        this.assertBounds(1);
        this.buffer.put(this.offset, value);
    }

    public void setByte(int index, byte value) {
        this.assertBounds(index + 1);
        this.buffer.put(this.offset + index, value);
    }

    public char getUByte() {
        this.assertBounds(1);
        return (char)(this.buffer.get(this.offset) & 0xFF);
    }

    public char getUByte(int index) {
        this.assertBounds(index + 1);
        return (char)(this.buffer.get(this.offset + index) & 0xFF);
    }

    public void setUByte(byte value) {
        this.assertBounds(1);
        this.buffer.put(this.offset, value);
    }

    public void setUByte(int index, byte value) {
        this.assertBounds(index + 1);
        this.buffer.put(this.offset + index, value);
    }

    public void setUByte(char value) {
        if ((long)value >= 256L) {
            throw new IllegalArgumentException("UByte out of range: " + value);
        }
        this.assertBounds(1);
        this.buffer.put(this.offset, (byte)value);
    }

    public void setUByte(int index, char value) {
        if ((long)value >= 256L) {
            throw new IllegalArgumentException("UByte out of range: " + value);
        }
        this.assertBounds(index + 1);
        this.buffer.put(this.offset + index, (byte)value);
    }

    public char getChar() {
        this.assertBounds(2);
        return this.buffer.getChar(this.offset);
    }

    public char getChar(int index) {
        this.assertBounds(index + 2);
        return this.buffer.getChar(this.offset + index);
    }

    public void setChar(char value) {
        this.assertBounds(2);
        this.buffer.putChar(this.offset, value);
    }

    public void setChar(int index, char value) {
        this.assertBounds(index + 2);
        this.buffer.putChar(this.offset + index, value);
    }

    public short getShort() {
        this.assertBounds(2);
        return this.buffer.getShort(this.offset);
    }

    public short getShort(int index) {
        this.assertBounds(index + 2);
        return this.buffer.getShort(this.offset + index);
    }

    public void setShort(short value) {
        this.assertBounds(2);
        this.buffer.putShort(this.offset, value);
    }

    public void setShort(int index, short value) {
        this.assertBounds(index + 2);
        this.buffer.putShort(this.offset + index, value);
    }

    public int getInt() {
        this.assertBounds(4);
        return this.buffer.getInt(this.offset);
    }

    public int getInt(int index) {
        this.assertBounds(index + 4);
        return this.buffer.getInt(this.offset + index);
    }

    public void setInt(int value) {
        this.assertBounds(4);
        this.buffer.putInt(this.offset, value);
    }

    public void setInt(int index, int value) {
        this.assertBounds(index + 4);
        this.buffer.putInt(this.offset + index, value);
    }

    public long getUInt() {
        this.assertBounds(4);
        return (long)this.buffer.getInt(this.offset) & 0xFFFFFFFFL;
    }

    public long getUInt(int index) {
        this.assertBounds(index + 4);
        return (long)this.buffer.getInt(this.offset + index) & 0xFFFFFFFFL;
    }

    public void setUInt(int value) {
        this.assertBounds(4);
        this.buffer.putInt(this.offset, value);
    }

    public void setUInt(int index, int value) {
        this.assertBounds(index + 4);
        this.buffer.putInt(this.offset + index, value);
    }

    public void setUInt(long value) {
        if (value >= 0x100000000L) {
            throw new IllegalArgumentException("UInt out of range: " + value);
        }
        this.assertBounds(4);
        this.buffer.putInt(this.offset, (int)value);
    }

    public void setUInt(int index, long value) {
        if (value >= 0x100000000L) {
            throw new IllegalArgumentException("UInt out of range: " + value);
        }
        this.assertBounds(index + 4);
        this.buffer.putInt(this.offset + index, (int)value);
    }

    public long getLong() {
        this.assertBounds(8);
        return this.buffer.getLong(this.offset);
    }

    public long getLong(int index) {
        this.assertBounds(index + 8);
        return this.buffer.getLong(this.offset + index);
    }

    public void setLong(long value) {
        this.assertBounds(8);
        this.buffer.putLong(this.offset, value);
    }

    public void setLong(int index, long value) {
        this.assertBounds(index + 8);
        this.buffer.putLong(this.offset + index, value);
    }

    public float getFloat() {
        this.assertBounds(4);
        return this.buffer.getFloat(this.offset);
    }

    public float getFloat(int index) {
        this.assertBounds(index + 4);
        return this.buffer.getFloat(this.offset + index);
    }

    public void setFloat(float value) {
        this.assertBounds(4);
        this.buffer.putFloat(this.offset, value);
    }

    public void setFloat(int index, float value) {
        this.assertBounds(index + 4);
        this.buffer.putFloat(this.offset + index, value);
    }

    public double getDouble() {
        this.assertBounds(8);
        return this.buffer.getDouble(this.offset);
    }

    public double getDouble(int index) {
        this.assertBounds(index + 8);
        return this.buffer.getDouble(this.offset + index);
    }

    public void setDouble(double value) {
        this.assertBounds(8);
        this.buffer.putDouble(this.offset, value);
    }

    public void setDouble(int index, double value) {
        this.assertBounds(index + 8);
        this.buffer.putDouble(this.offset + index, value);
    }

    public long getNativePointer() {
        this.assertBounds(CHandler.POINTER_SIZE);
        if (CHandler.POINTER_SIZE == 4) {
            return this.buffer.getInt(this.offset);
        }
        return this.buffer.getLong(this.offset);
    }

    public long getNativePointer(int index) {
        this.assertBounds(index + CHandler.POINTER_SIZE);
        if (CHandler.POINTER_SIZE == 4) {
            return this.buffer.getInt(this.offset + index);
        }
        return this.buffer.getLong(this.offset + index);
    }

    public void setNativePointer(long value) {
        this.assertBounds(CHandler.POINTER_SIZE);
        if (CHandler.POINTER_SIZE == 4) {
            this.buffer.putInt(this.offset, (int)value);
        } else {
            this.buffer.putLong(this.offset, value);
        }
    }

    public void setNativePointer(int index, long value) {
        this.assertBounds(index + CHandler.POINTER_SIZE);
        if (CHandler.POINTER_SIZE == 4) {
            this.buffer.putInt(this.offset + index, (int)value);
        } else {
            this.buffer.putLong(this.offset + index, value);
        }
    }

    public long getNativeLong() {
        this.assertBounds(CHandler.LONG_SIZE);
        if (CHandler.LONG_SIZE == 4) {
            return this.buffer.getInt(this.offset);
        }
        return this.buffer.getLong(this.offset);
    }

    public long getNativeLong(int index) {
        this.assertBounds(index + CHandler.LONG_SIZE);
        if (CHandler.LONG_SIZE == 4) {
            return this.buffer.getInt(this.offset + index);
        }
        return this.buffer.getLong(this.offset + index);
    }

    public void setNativeLong(long value) {
        this.assertBounds(CHandler.LONG_SIZE);
        if (CHandler.LONG_SIZE == 4) {
            this.buffer.putInt(this.offset, (int)value);
        } else {
            this.buffer.putLong(this.offset, value);
        }
    }

    public void setNativeLong(int index, long value) {
        this.assertBounds(index + CHandler.LONG_SIZE);
        if (CHandler.LONG_SIZE == 4) {
            this.buffer.putInt(this.offset + index, (int)value);
        } else {
            this.buffer.putLong(this.offset + index, value);
        }
    }

    public long getNativeULong() {
        this.assertBounds(CHandler.LONG_SIZE);
        if (CHandler.LONG_SIZE == 4) {
            return (long)this.buffer.getInt(this.offset) & 0xFFFFFFFFL;
        }
        return this.buffer.getLong(this.offset);
    }

    public long getNativeULong(int index) {
        this.assertBounds(index + CHandler.LONG_SIZE);
        if (CHandler.LONG_SIZE == 4) {
            return (long)this.buffer.getInt(this.offset + index) & 0xFFFFFFFFL;
        }
        return this.buffer.getLong(this.offset + index);
    }

    public void setNativeULong(long value) {
        this.assertBounds(CHandler.LONG_SIZE);
        if (CHandler.LONG_SIZE == 4) {
            this.buffer.putInt(this.offset, (int)value);
        } else {
            this.buffer.putLong(this.offset, value);
        }
    }

    public void setNativeULong(int index, long value) {
        this.assertBounds(index + CHandler.LONG_SIZE);
        if (CHandler.LONG_SIZE == 4) {
            this.buffer.putInt(this.offset + index, (int)value);
        } else {
            this.buffer.putLong(this.offset + index, value);
        }
    }

    public String getString() {
        return this.getString(StandardCharsets.UTF_8);
    }

    public String getString(Charset charset) {
        int length = 0;
        while (this.buffer.get(this.offset + length) != 0) {
            ++length;
        }
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = this.buffer.get(this.offset + i);
        }
        return new String(bytes, charset);
    }

    public void setString(String string) {
        this.setString(string, StandardCharsets.UTF_8);
    }

    public void setString(String string, Charset charset) {
        byte[] bytes = string.getBytes(charset);
        this.assertBounds(bytes.length + 1);
        for (int i = 0; i < bytes.length; ++i) {
            this.buffer.put(this.offset + i, bytes[i]);
        }
        this.buffer.put(this.offset + bytes.length, (byte)0);
    }

    public void copyFrom(BufferPtr src, int size) {
        this.assertBounds(size);
        src.assertBounds(size);
        CHandler.memcpy(this.pointer, src.pointer, size);
    }

    public void copyFrom(int index, BufferPtr src, int srcOffset, int size) {
        this.assertBounds(index + size);
        src.assertBounds(srcOffset + size);
        CHandler.memcpy(this.pointer + (long)index, src.pointer + (long)srcOffset, size);
    }

    public long duplicate() {
        if (this.isNull()) {
            throw new NullPointerException("Buffer is null");
        }
        if (!this.hasCapacity()) {
            throw new IllegalStateException("Can't clone buffer with zero or non capacity");
        }
        return CHandler.clone(this.pointer, this.capacity);
    }

    public long duplicate(int offset, int size) {
        this.assertBounds(offset + size);
        return CHandler.clone(this.pointer + (long)offset, size);
    }

    public long getPointer() {
        if (this.buffer == null) {
            throw new IllegalStateException("Buffer invalid (use-after-free?)");
        }
        return this.pointer;
    }

    public boolean hasCapacity() {
        if (this.buffer == null) {
            throw new IllegalStateException("Buffer invalid (use-after-free?)");
        }
        return this.capacity > 0;
    }

    public int getCapacity() {
        if (this.buffer == null) {
            throw new IllegalStateException("Buffer invalid (use-after-free?)");
        }
        return this.capacity;
    }

    public boolean isNull() {
        if (this.buffer == null) {
            throw new IllegalStateException("Buffer invalid (use-after-free?)");
        }
        return this.pointer == 0L;
    }
}

