/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.runtime.mem;

import com.badlogic.gdx.jnigen.runtime.CHandler;
import com.badlogic.gdx.jnigen.runtime.mem.BufferPtr;
import com.badlogic.gdx.jnigen.runtime.mem.BufferPtrPool;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collection;

public class BufferPtrManager {
    private static final int L1_BITS = 12;
    private static final int L2_BITS = 11;
    private static final int L3_BITS = 11;
    private static final int PAGE_OFFSET_BITS = 30;
    private static final int L1_SIZE = 4096;
    private static final int L2_SIZE = 2048;
    private static final int L3_SIZE = 2048;
    private static final int PAGE_SIZE = 0x40000000;
    private static final int L1_MASK = 4095;
    private static final int L2_MASK = 2047;
    private static final int L3_MASK = 2047;
    private static final long PAGE_OFFSET_MASK = 0x3FFFFFFFL;
    private static final long ADDRESS_MASK = -1073741824L;
    private static final ByteBuffer[][][] BUFFER_CACHE = new ByteBuffer[4096][][];
    private static final ByteBuffer NULL_BUFFER = CHandler.wrapPointer(0L, Integer.MAX_VALUE);
    private static final boolean NO_POOLING = System.getProperty("com.badlogic.jnigen.allocator.no_pooling", "false").equals("true");
    private static final int POOL_SIZE = Integer.parseInt(System.getProperty("com.badlogic.jnigen.allocator.pool_size", "256"));
    private static final BufferPtrPool BUFFER_PTR_POOL = new BufferPtrPool(POOL_SIZE);

    private static ByteBuffer getBuffer(long basePtr) {
        ByteBuffer L3;
        ByteBuffer[] L2;
        if (basePtr == 0L) {
            return NULL_BUFFER;
        }
        int l1_index = (int)(basePtr >> 52) & 0xFFF;
        int l2_index = (int)(basePtr >> 41) & 0x7FF;
        int l3_index = (int)(basePtr >> 30) & 0x7FF;
        ByteBuffer[][] L1 = BUFFER_CACHE[l1_index];
        if (L1 == null) {
            L1 = new ByteBuffer[2048][];
            BufferPtrManager.BUFFER_CACHE[l1_index] = L1;
        }
        if ((L2 = L1[l2_index]) == null) {
            L2 = new ByteBuffer[2048];
            L1[l2_index] = L2;
        }
        if ((L3 = L2[l3_index]) == null) {
            L2[l3_index] = L3 = CHandler.wrapPointer(basePtr, Integer.MAX_VALUE).order(ByteOrder.nativeOrder());
        }
        return L3;
    }

    public static BufferPtr get(long pointer) {
        return BufferPtrManager.get(pointer, -1);
    }

    public static BufferPtr get(long pointer, int capacity) {
        if (pointer == 0L) {
            return new BufferPtr(NULL_BUFFER, 0L, 0, 0);
        }
        if (capacity > 0x40000000) {
            throw new IllegalArgumentException("capacity > PAGE_SIZE (" + capacity + " > " + 0x40000000 + ")");
        }
        int offset = (int)(pointer & 0x3FFFFFFFL);
        long basePtr = pointer & 0xFFFFFFFFC0000000L;
        ByteBuffer buffer = BufferPtrManager.getBuffer(basePtr);
        if (NO_POOLING) {
            return new BufferPtr(buffer, pointer, offset, capacity);
        }
        BufferPtr bufferPtr = BUFFER_PTR_POOL.pollOrCreate();
        bufferPtr.reset(buffer, pointer, offset, capacity);
        return bufferPtr;
    }

    public static void setBufferPtrPointer(BufferPtr bufferPtr, long newPointer) {
        BufferPtrManager.setBufferPtrPointer(bufferPtr, newPointer, -1);
    }

    public static void setBufferPtrPointer(BufferPtr bufferPtr, long newPointer, int capacity) {
        int offset = (int)(newPointer & 0x3FFFFFFFL);
        long basePtr = newPointer & 0xFFFFFFFFC0000000L;
        ByteBuffer buffer = BufferPtrManager.getBuffer(basePtr);
        bufferPtr.reset(buffer, newPointer, offset, capacity);
    }

    public static void insertPool(BufferPtr bufferPtr) {
        if (NO_POOLING) {
            return;
        }
        BUFFER_PTR_POOL.offer(bufferPtr);
    }

    public static void insertPool(Collection<BufferPtr> bufferPtr) {
        if (NO_POOLING) {
            return;
        }
        BUFFER_PTR_POOL.offerAll(bufferPtr);
    }

    public static void reset() {
        Arrays.fill((Object[])BUFFER_CACHE, null);
        BUFFER_PTR_POOL.clear();
    }

    public static boolean isPoolingEnabled() {
        return !NO_POOLING;
    }

    public static int getMaxPoolSize() {
        return POOL_SIZE;
    }
}

