/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.runtime.pointer;

import com.badlogic.gdx.jnigen.runtime.pointer.VoidPointer;

public final class DoublePointer
extends VoidPointer {
    private static final int __double_size = 8;

    public DoublePointer(VoidPointer pointer) {
        super(pointer);
    }

    public DoublePointer(long pointer, boolean freeOnGC) {
        super(pointer, freeOnGC);
    }

    public DoublePointer(long pointer, boolean freeOnGC, int capacity) {
        super(pointer, freeOnGC, capacity * 8);
    }

    public DoublePointer() {
        this(1);
    }

    public DoublePointer(int size) {
        this(size, true);
    }

    public DoublePointer(int size, boolean freeOnGC) {
        super(8 * size, freeOnGC);
    }

    public double getDouble() {
        return this.getDouble(0);
    }

    public double getDouble(int index) {
        int offset = index * 8;
        return this.getBufPtr().getDouble(offset);
    }

    public void setDouble(double value) {
        this.setDouble(value, 0);
    }

    public void setDouble(double value, int index) {
        int offset = index * 8;
        this.getBufPtr().setDouble(offset, value);
    }
}

