/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.runtime.pointer;

import com.badlogic.gdx.jnigen.runtime.pointer.VoidPointer;

public final class FloatPointer
extends VoidPointer {
    private static final int __float_size = 4;

    public FloatPointer(VoidPointer pointer) {
        super(pointer);
    }

    public FloatPointer(long pointer, boolean freeOnGC) {
        super(pointer, freeOnGC);
    }

    public FloatPointer(long pointer, boolean freeOnGC, int capacity) {
        super(pointer, freeOnGC, capacity * 4);
    }

    public FloatPointer() {
        this(1);
    }

    public FloatPointer(int size) {
        this(size, true);
    }

    public FloatPointer(int size, boolean freeOnGC) {
        super(4 * size, freeOnGC);
    }

    public float getFloat() {
        return this.getFloat(0);
    }

    public float getFloat(int index) {
        int offset = index * 4;
        return this.getBufPtr().getFloat(offset);
    }

    public void setFloat(float value) {
        this.setFloat(value, 0);
    }

    public void setFloat(float value, int index) {
        int offset = index * 4;
        this.getBufPtr().setFloat(offset, value);
    }
}

