/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.runtime.pointer;

import com.badlogic.gdx.jnigen.runtime.gc.GCHandler;
import com.badlogic.gdx.jnigen.runtime.mem.AllocationManager;
import com.badlogic.gdx.jnigen.runtime.mem.BufferPtr;
import com.badlogic.gdx.jnigen.runtime.mem.BufferPtrManager;

public abstract class Pointing {
    private final BufferPtr bufPtr;
    private final boolean freeOnGC;
    private Pointing parent;
    protected boolean freed = false;

    public Pointing(Pointing pointing) {
        this.bufPtr = AllocationManager.wrap(pointing.getPointer(), pointing.getCapacity());
        this.freeOnGC = false;
        this.parent = pointing;
    }

    public Pointing(long pointer, boolean freeOnGC) {
        this.bufPtr = AllocationManager.wrap(pointer);
        this.freeOnGC = freeOnGC;
        if (freeOnGC) {
            GCHandler.enqueuePointer(this, this.bufPtr);
        }
    }

    public Pointing(long pointer, boolean freeOnGC, int capacity) {
        this.bufPtr = AllocationManager.wrap(pointer, capacity);
        this.freeOnGC = freeOnGC;
        if (freeOnGC) {
            GCHandler.enqueuePointer(this, this.bufPtr);
        }
    }

    public Pointing(int size, boolean freeOnGC) {
        this.bufPtr = AllocationManager.allocate(size);
        this.freeOnGC = freeOnGC;
        if (freeOnGC) {
            GCHandler.enqueuePointer(this, this.bufPtr);
        }
    }

    public boolean isNull() {
        if (this.freed) {
            throw new IllegalStateException("Pointer is freed: " + this.bufPtr.getPointer());
        }
        return this.bufPtr.isNull();
    }

    public void assertBounds(int index) {
        if (this.freed) {
            throw new IllegalStateException("Pointer is freed: " + this.bufPtr.getPointer());
        }
        if (this.isNull()) {
            throw new NullPointerException("Pointer is null");
        }
        this.bufPtr.assertBounds(index);
    }

    public void free() {
        if (this.freed) {
            throw new IllegalStateException("Double free on " + this.bufPtr.getPointer());
        }
        if (this.freeOnGC) {
            throw new IllegalStateException("Can only free unmanaged objects");
        }
        if (this.parent != null) {
            throw new IllegalStateException("Can't free object that has parent");
        }
        if (this.isNull()) {
            throw new NullPointerException("Pointer is null");
        }
        this.bufPtr.free();
        this.freed = true;
    }

    public boolean isFreed() {
        return this.freed;
    }

    public void setParent(Pointing parent) {
        this.parent = parent;
    }

    public BufferPtr getBufPtr() {
        if (this.freed) {
            throw new IllegalStateException("Pointer is freed: " + this.bufPtr.getPointer());
        }
        if (this.isNull()) {
            throw new NullPointerException("Pointer is null");
        }
        return this.bufPtr;
    }

    public void setPointer(long pointer) {
        if (this.freeOnGC) {
            throw new IllegalStateException("Can't change address of GC registered pointer");
        }
        BufferPtrManager.setBufferPtrPointer(this.bufPtr, pointer);
        this.freed = false;
        this.parent = null;
    }

    public void setPointer(long pointer, Pointing parent) {
        if (this.freeOnGC) {
            throw new IllegalStateException("Can't change address of GC registered pointer");
        }
        BufferPtrManager.setBufferPtrPointer(this.bufPtr, pointer);
        this.freed = false;
        this.parent = parent;
    }

    public void setPointer(long pointer, int capacity) {
        if (this.freeOnGC) {
            throw new IllegalStateException("Can't change address of GC registered pointer");
        }
        BufferPtrManager.setBufferPtrPointer(this.bufPtr, pointer, capacity);
        this.freed = false;
        this.parent = null;
    }

    public void setPointer(long pointer, int capacity, Pointing parent) {
        if (this.freeOnGC) {
            throw new IllegalStateException("Can't change address of GC registered pointer");
        }
        BufferPtrManager.setBufferPtrPointer(this.bufPtr, pointer, capacity);
        this.freed = false;
        this.parent = parent;
    }

    public void setPointer(Pointing pointer) {
        if (this.freeOnGC) {
            throw new IllegalStateException("Can't change address of GC registered pointer");
        }
        BufferPtrManager.setBufferPtrPointer(this.bufPtr, pointer.getPointer(), pointer.getCapacity());
        this.freed = false;
        this.parent = pointer;
    }

    public long getPointer() {
        if (this.freed) {
            throw new IllegalStateException("Pointer is freed: " + this.bufPtr.getPointer());
        }
        return this.bufPtr.getPointer();
    }

    public int getCapacity() {
        if (this.freed) {
            throw new IllegalStateException("Pointer is freed: " + this.bufPtr.getPointer());
        }
        return this.bufPtr.getCapacity();
    }
}

