/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.runtime.pointer;

import com.badlogic.gdx.jnigen.runtime.CHandler;
import com.badlogic.gdx.jnigen.runtime.pointer.Pointing;
import com.badlogic.gdx.jnigen.runtime.pointer.StackElement;
import com.badlogic.gdx.jnigen.runtime.pointer.VoidPointer;

public abstract class StackElementPointer<T extends StackElement>
extends VoidPointer {
    public StackElementPointer(VoidPointer pointer) {
        super(pointer);
    }

    protected StackElementPointer(long pointer, boolean freeOnGC) {
        super(pointer, freeOnGC);
    }

    protected StackElementPointer(long pointer, boolean freeOnGC, int capacity) {
        super(pointer, freeOnGC, capacity);
    }

    public StackElementPointer(int size, int count) {
        this(size, count, true);
    }

    public StackElementPointer(int size, int count, boolean freeOnGC) {
        super(size * count, freeOnGC);
    }

    public void get(T toWrite) {
        ((Pointing)toWrite).getBufPtr().copyFrom(this.getBufPtr(), this.getSize());
    }

    public void get(int index, T toWrite) {
        int offset = this.getSize() * index;
        ((Pointing)toWrite).getBufPtr().copyFrom(0, this.getBufPtr(), offset, this.getSize());
    }

    public T get() {
        return this.get(0);
    }

    public T get(int index) {
        int offset = this.getSize() * index;
        this.assertBounds(offset);
        long newPtr = CHandler.clone(this.getPointer() + (long)offset, this.getSize());
        return this.createStackElement(newPtr, true);
    }

    public T asStackElement() {
        return this.asStackElement(0);
    }

    public T asStackElement(int index) {
        int offset = this.getSize() * index;
        this.assertBounds(offset);
        T stackElement = this.createStackElement(this.getPointer() + (long)offset, false);
        ((Pointing)stackElement).setParent(this);
        return stackElement;
    }

    public void asStackElement(T toSetPtr) {
        this.asStackElement(0, toSetPtr);
    }

    public void asStackElement(int index, T toSetPtr) {
        int offset = this.getSize() * index;
        this.assertBounds(offset);
        ((Pointing)toSetPtr).setPointer(this.getPointer() + (long)offset, this.getSize(), this);
    }

    public void set(T toSet) {
        this.getBufPtr().copyFrom(((Pointing)toSet).getBufPtr(), this.getSize());
    }

    public void set(T toSet, int index) {
        int offset = this.getSize() * index;
        this.getBufPtr().copyFrom(offset, ((Pointing)toSet).getBufPtr(), 0, this.getSize());
    }

    protected abstract int getSize();

    protected abstract T createStackElement(long var1, boolean var3);
}

