/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.runtime.pointer.integer;

import com.badlogic.gdx.jnigen.runtime.CHandler;
import com.badlogic.gdx.jnigen.runtime.pointer.VoidPointer;
import com.badlogic.gdx.jnigen.runtime.util.Utils;

public class BytePointer
extends VoidPointer {
    private static final int BYTE_SIZE = 1;
    private static final boolean IS_CHAR_SIGNED = CHandler.IS_CHAR_SIGNED;

    public BytePointer(VoidPointer pointer) {
        super(pointer);
    }

    public BytePointer(int count, boolean freeOnGC) {
        super(count * 1, freeOnGC);
    }

    public BytePointer() {
        this(1);
    }

    public BytePointer(int count) {
        super(count * 1);
    }

    public BytePointer(long pointer, boolean freeOnGC) {
        super(pointer, freeOnGC);
    }

    public BytePointer(long pointer, boolean freeOnGC, int capacity) {
        super(pointer, freeOnGC, capacity * 1);
    }

    public boolean getBoolean() {
        return this.getBoolean(0);
    }

    public boolean getBoolean(int index) {
        return this.getBufPtr().getBoolean(index * 1);
    }

    public void setBoolean(boolean value) {
        this.setBoolean(value, 0);
    }

    public void setBoolean(boolean value, int index) {
        this.getBufPtr().setBoolean(index * 1, value);
    }

    public byte getByte() {
        return this.getByte(0);
    }

    public byte getByte(int index) {
        return this.getBufPtr().getByte(index * 1);
    }

    public void setByte(byte value) {
        this.setByte(value, 0);
    }

    public void setByte(byte value, int index) {
        if (IS_CHAR_SIGNED) {
            this.setByte((char)value, index);
        } else {
            this.setByte((char)(value & 0xFF), index);
        }
    }

    public void setByte(char value) {
        this.setByte(value, 0);
    }

    public void setByte(char value, int index) {
        if (Utils.checkBoundsForNumber(value, 1L, IS_CHAR_SIGNED)) {
            throw new IllegalArgumentException("Byte out of range: " + value);
        }
        this.getBufPtr().setByte(index, (byte)value);
    }

    public static BytePointer fromString(String string, boolean freeOnGC) {
        BytePointer pointer = new BytePointer(string.getBytes().length + 1, freeOnGC);
        pointer.setString(string);
        return pointer;
    }

    public void setString(String string) {
        this.getBufPtr().setString(string);
    }

    public String getString() {
        return this.getBufPtr().getString();
    }
}

