/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.runtime.pointer.integer;

import com.badlogic.gdx.jnigen.runtime.pointer.VoidPointer;

public class SBytePointer
extends VoidPointer {
    private static final int BYTE_SIZE = 1;

    public SBytePointer(VoidPointer pointer) {
        super(pointer);
    }

    public SBytePointer(int count, boolean freeOnGC) {
        super(count * 1, freeOnGC);
    }

    public SBytePointer() {
        this(1);
    }

    public SBytePointer(int count) {
        super(count * 1);
    }

    public SBytePointer(long pointer, boolean freeOnGC) {
        super(pointer, freeOnGC);
    }

    public SBytePointer(long pointer, boolean freeOnGC, int capacity) {
        super(pointer, freeOnGC, capacity * 1);
    }

    public boolean getBoolean() {
        return this.getBoolean(0);
    }

    public boolean getBoolean(int index) {
        return this.getBufPtr().getBoolean(index * 1);
    }

    public void setBoolean(boolean value) {
        this.setBoolean(value, 0);
    }

    public void setBoolean(boolean value, int index) {
        this.getBufPtr().setBoolean(index * 1, value);
    }

    public byte getByte() {
        return this.getByte(0);
    }

    public byte getByte(int index) {
        return this.getBufPtr().getByte(index * 1);
    }

    public void setByte(byte value) {
        this.setByte(value, 0);
    }

    public void setByte(byte value, int index) {
        this.getBufPtr().setByte(index * 1, value);
    }

    public static SBytePointer fromString(String string, boolean freeOnGC) {
        SBytePointer pointer = new SBytePointer(string.getBytes().length + 1, freeOnGC);
        pointer.setString(string);
        return pointer;
    }

    public void setString(String string) {
        this.getBufPtr().setString(string);
    }

    public String getString() {
        return this.getBufPtr().getString();
    }
}

