/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.runtime.pointer.integer;

import com.badlogic.gdx.jnigen.runtime.pointer.VoidPointer;

public class SIntPointer
extends VoidPointer {
    private static final int BYTE_SIZE = 4;

    public SIntPointer(VoidPointer pointer) {
        super(pointer);
    }

    public SIntPointer(int count, boolean freeOnGC) {
        super(count * 4, freeOnGC);
    }

    public SIntPointer() {
        this(1);
    }

    public SIntPointer(int count) {
        super(count * 4);
    }

    public SIntPointer(long pointer, boolean freeOnGC) {
        super(pointer, freeOnGC);
    }

    public SIntPointer(long pointer, boolean freeOnGC, int capacity) {
        super(pointer, freeOnGC, capacity * 4);
    }

    public int getInt() {
        return this.getInt(0);
    }

    public int getInt(int index) {
        return this.getBufPtr().getInt(index * 4);
    }

    public void setInt(int value) {
        this.setInt(value, 0);
    }

    public void setInt(int value, int index) {
        this.getBufPtr().setInt(index * 4, value);
    }
}

