/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.runtime.pointer.integer;

import com.badlogic.gdx.jnigen.runtime.pointer.VoidPointer;

public class UBytePointer
extends VoidPointer {
    private static final int BYTE_SIZE = 1;

    public UBytePointer(VoidPointer pointer) {
        super(pointer);
    }

    public UBytePointer(int count, boolean freeOnGC) {
        super(count * 1, freeOnGC);
    }

    public UBytePointer() {
        this(1);
    }

    public UBytePointer(int count) {
        super(count * 1);
    }

    public UBytePointer(long pointer, boolean freeOnGC) {
        super(pointer, freeOnGC);
    }

    public UBytePointer(long pointer, boolean freeOnGC, int capacity) {
        super(pointer, freeOnGC, capacity * 1);
    }

    public boolean getBoolean() {
        return this.getBoolean(0);
    }

    public boolean getBoolean(int index) {
        return this.getBufPtr().getBoolean(index * 1);
    }

    public void setBoolean(boolean value) {
        this.setBoolean(value, 0);
    }

    public void setBoolean(boolean value, int index) {
        this.getBufPtr().setBoolean(index * 1, value);
    }

    public char getUByte() {
        return this.getUByte(0);
    }

    public char getUByte(int index) {
        return this.getBufPtr().getUByte(index * 1);
    }

    public void setUByte(byte value) {
        this.setUByte(value, 0);
    }

    public void setUByte(byte value, int index) {
        this.getBufPtr().setUByte(index * 1, value);
    }

    public void setUByte(char value) {
        this.setUByte(value, 0);
    }

    public void setUByte(char value, int index) {
        this.getBufPtr().setUByte(index * 1, (byte)value);
    }

    public static UBytePointer fromString(String string, boolean freeOnGC) {
        UBytePointer pointer = new UBytePointer(string.getBytes().length + 1, freeOnGC);
        pointer.setString(string);
        return pointer;
    }

    public void setString(String string) {
        this.getBufPtr().setString(string);
    }

    public String getString() {
        return this.getBufPtr().getString();
    }
}

