/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.runtime.pointer.integer;

import com.badlogic.gdx.jnigen.runtime.pointer.VoidPointer;

public class UInt64Pointer
extends VoidPointer {
    private static final int BYTE_SIZE = 8;

    public UInt64Pointer(VoidPointer pointer) {
        super(pointer);
    }

    public UInt64Pointer(int count, boolean freeOnGC) {
        super(count * 8, freeOnGC);
    }

    public UInt64Pointer() {
        this(1);
    }

    public UInt64Pointer(int count) {
        super(count * 8);
    }

    public UInt64Pointer(long pointer, boolean freeOnGC) {
        super(pointer, freeOnGC);
    }

    public UInt64Pointer(long pointer, boolean freeOnGC, int capacity) {
        super(pointer, freeOnGC, capacity * 8);
    }

    public long getLong() {
        return this.getLong(0);
    }

    public long getLong(int index) {
        return this.getBufPtr().getLong(index * 8);
    }

    public void setLong(long value) {
        this.setLong(value, 0);
    }

    public void setLong(long value, int index) {
        this.getBufPtr().setLong(index * 8, value);
    }
}

