/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.runtime.pointer.integer;

import com.badlogic.gdx.jnigen.runtime.pointer.VoidPointer;

public class UIntPointer
extends VoidPointer {
    private static final int BYTE_SIZE = 4;

    public UIntPointer(VoidPointer pointer) {
        super(pointer);
    }

    public UIntPointer(int count, boolean freeOnGC) {
        super(count * 4, freeOnGC);
    }

    public UIntPointer() {
        this(1);
    }

    public UIntPointer(int count) {
        super(count * 4);
    }

    public UIntPointer(long pointer, boolean freeOnGC) {
        super(pointer, freeOnGC);
    }

    public UIntPointer(long pointer, boolean freeOnGC, int capacity) {
        super(pointer, freeOnGC, capacity * 4);
    }

    public long getUInt() {
        return this.getUInt(0);
    }

    public long getUInt(int index) {
        return this.getBufPtr().getUInt(index * 4);
    }

    public void setUInt(int value) {
        this.setUInt(value, 0);
    }

    public void setUInt(int value, int index) {
        this.getBufPtr().setUInt(index * 4, value);
    }

    public void setUInt(long value) {
        this.setUInt(value, 0);
    }

    public void setUInt(long value, int index) {
        this.getBufPtr().setUInt(index * 4, value);
    }
}

