/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.runtime.pointer.integer;

import com.badlogic.gdx.jnigen.runtime.pointer.VoidPointer;

public class UShortPointer
extends VoidPointer {
    private static final int BYTE_SIZE = 2;

    public UShortPointer(VoidPointer pointer) {
        super(pointer);
    }

    public UShortPointer(int count, boolean freeOnGC) {
        super(count * 2, freeOnGC);
    }

    public UShortPointer() {
        this(1);
    }

    public UShortPointer(int count) {
        super(count * 2);
    }

    public UShortPointer(long pointer, boolean freeOnGC, int capacity) {
        super(pointer, freeOnGC, capacity * 2);
    }

    public char getUShort() {
        return this.getUShort(0);
    }

    public char getUShort(int index) {
        return this.getBufPtr().getChar(index * 2);
    }

    public void setUShort(char value) {
        this.setUShort(value, 0);
    }

    public void setUShort(char value, int index) {
        this.getBufPtr().setChar(index * 2, value);
    }
}

